/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.rfc5545.recur;

import java.util.List;
import org.dmfs.rfc5545.Instance;
import org.dmfs.rfc5545.calendarmetrics.CalendarMetrics;
import org.dmfs.rfc5545.recur.ByExpander;
import org.dmfs.rfc5545.recur.RecurrenceRule;
import org.dmfs.rfc5545.recur.RuleIterator;

final class ByDayYearlyExpander
extends ByExpander {
    private final int[] mByDay;

    private static int packWeekday(int pos, int day) {
        return (pos << 8) + day;
    }

    private static int unpackWeekday(int packedDay) {
        return packedDay & 0xFF;
    }

    private static int unpackPos(int packedDay) {
        return packedDay >> 8;
    }

    public ByDayYearlyExpander(RecurrenceRule rule, RuleIterator previous, CalendarMetrics calendarTools, long start) {
        super(previous, calendarTools, start);
        List<RecurrenceRule.WeekdayNum> byDay = rule.getByDayPart();
        this.mByDay = new int[byDay.size()];
        int l = byDay.size();
        for (int i = 0; i < l; ++i) {
            RecurrenceRule.WeekdayNum weekdayNum = byDay.get(i);
            this.mByDay[i] = ByDayYearlyExpander.packWeekday(weekdayNum.pos, weekdayNum.weekday.ordinal());
        }
    }

    @Override
    void expand(long instance, long start) {
        CalendarMetrics calendarMetrics = this.mCalendarMetrics;
        int year = Instance.year((long)instance);
        for (int packedDay : this.mByDay) {
            int dayOfYear;
            int monthAndDay;
            int dayOfYear2;
            int pos = ByDayYearlyExpander.unpackPos(packedDay);
            int day = ByDayYearlyExpander.unpackWeekday(packedDay);
            int firstWeekdayOfYear = (day - calendarMetrics.getWeekDayOfFirstYearDay(year) + 7) % 7 + 1;
            int yearDays = calendarMetrics.getDaysPerYear(year);
            if (pos == 0) {
                for (dayOfYear2 = firstWeekdayOfYear; dayOfYear2 <= yearDays; dayOfYear2 += 7) {
                    monthAndDay = calendarMetrics.getMonthAndDayOfYearDay(year, dayOfYear2);
                    this.addInstance(Instance.setMonthAndDayOfMonth((long)instance, (int)CalendarMetrics.packedMonth((int)monthAndDay), (int)CalendarMetrics.dayOfMonth((int)monthAndDay)));
                }
                continue;
            }
            if (pos > 0) {
                dayOfYear2 = firstWeekdayOfYear + (pos - 1) * 7;
                if (dayOfYear2 > yearDays) continue;
                monthAndDay = calendarMetrics.getMonthAndDayOfYearDay(year, dayOfYear2);
                this.addInstance(Instance.setMonthAndDayOfMonth((long)instance, (int)CalendarMetrics.packedMonth((int)monthAndDay), (int)CalendarMetrics.dayOfMonth((int)monthAndDay)));
                continue;
            }
            int lastWeekdayOfYear = firstWeekdayOfYear + yearDays - yearDays % 7;
            if (lastWeekdayOfYear > yearDays) {
                lastWeekdayOfYear -= 7;
            }
            if ((dayOfYear = lastWeekdayOfYear + (pos + 1) * 7) <= 0) continue;
            int monthAndDay2 = calendarMetrics.getMonthAndDayOfYearDay(year, dayOfYear);
            this.addInstance(Instance.setMonthAndDayOfMonth((long)instance, (int)CalendarMetrics.packedMonth((int)monthAndDay2), (int)CalendarMetrics.dayOfMonth((int)monthAndDay2)));
        }
    }
}

