/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.rfc5545.recur;

import java.util.Map;
import java.util.Set;
import org.dmfs.jems2.BiFunction;
import org.dmfs.rfc5545.Instance;
import org.dmfs.rfc5545.Weekday;
import org.dmfs.rfc5545.calendarmetrics.CalendarMetrics;
import org.dmfs.rfc5545.recur.ByFilter;

final class ByDayPrefixedFilter
implements ByFilter {
    private final CalendarMetrics mCalendarMetrics;
    private final Map<Weekday, Set<Integer>> mPrefixedWeekDays;
    private final Scope mScope;
    private final Weekday[] mWeekdayArray = Weekday.values();

    public ByDayPrefixedFilter(CalendarMetrics calendarMetrics, Map<Weekday, Set<Integer>> prefixedWeekDays, Scope scope) {
        this.mCalendarMetrics = calendarMetrics;
        this.mPrefixedWeekDays = prefixedWeekDays;
        this.mScope = scope;
    }

    @Override
    public boolean filter(long instance) {
        Set<Integer> prefixes = this.mPrefixedWeekDays.get(this.mWeekdayArray[this.mCalendarMetrics.getDayOfWeek(Instance.year((long)instance), Instance.month((long)instance), Instance.dayOfMonth((long)instance))]);
        return prefixes == null || !prefixes.contains(this.mScope.mNthDay.value((Object)instance, (Object)this.mCalendarMetrics)) && !prefixes.contains(this.mScope.mNthLastDay.value((Object)instance, (Object)this.mCalendarMetrics));
    }

    public static enum Scope {
        MONTH((BiFunction<Long, CalendarMetrics, Integer>)((BiFunction)(instance, metrics) -> (Instance.dayOfMonth((long)instance) - 1) / 7 + 1), (BiFunction<Long, CalendarMetrics, Integer>)((BiFunction)(instance, metrics) -> (Instance.dayOfMonth((long)instance) - metrics.getDaysPerPackedMonth(Instance.year((long)instance), Instance.month((long)instance))) / 7 - 1)),
        YEAR((BiFunction<Long, CalendarMetrics, Integer>)((BiFunction)(instance, metrics) -> (metrics.getDayOfYear(Instance.year((long)instance), Instance.month((long)instance), Instance.dayOfMonth((long)instance)) - 1) / 7 + 1), (BiFunction<Long, CalendarMetrics, Integer>)((BiFunction)(instance, metrics) -> (metrics.getDayOfYear(Instance.year((long)instance), Instance.month((long)instance), Instance.dayOfMonth((long)instance)) - metrics.getDaysPerYear(Instance.year((long)instance))) / 7 - 1));

        private final BiFunction<Long, CalendarMetrics, Integer> mNthDay;
        private final BiFunction<Long, CalendarMetrics, Integer> mNthLastDay;

        private Scope(BiFunction<Long, CalendarMetrics, Integer> nthDay, BiFunction<Long, CalendarMetrics, Integer> nthLastDay) {
            this.mNthDay = nthDay;
            this.mNthLastDay = nthLastDay;
        }
    }
}

