/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.rfc5545.iterable.instanceiterable;

import java.util.Arrays;
import java.util.TimeZone;
import org.dmfs.rfc5545.DateTime;
import org.dmfs.rfc5545.calendarmetrics.CalendarMetrics;
import org.dmfs.rfc5545.iterable.InstanceIterable;
import org.dmfs.rfc5545.iterable.InstanceIterator;

@Deprecated
public final class InstanceList
implements InstanceIterable {
    private final long[] mInstances;
    private final int mCount;

    public InstanceList(String list, TimeZone timeZone) {
        this(DateTime.GREGORIAN_CALENDAR_SCALE, list, timeZone);
    }

    public InstanceList(CalendarMetrics calendarMetrics, String list, TimeZone timeZone) {
        if (list == null || list.length() == 0) {
            this.mInstances = null;
            this.mCount = 0;
            return;
        }
        String[] instances = list.split(",");
        this.mInstances = new long[instances.length];
        int count = 0;
        for (String instanceString : instances) {
            DateTime instance = DateTime.parse((CalendarMetrics)calendarMetrics, (TimeZone)timeZone, (String)instanceString);
            this.mInstances[count] = instance.getTimestamp();
            ++count;
        }
        this.mCount = count;
        Arrays.sort(this.mInstances);
    }

    public InstanceList(long[] instances) {
        this.mInstances = new long[instances.length];
        System.arraycopy(instances, 0, this.mInstances, 0, instances.length);
        this.mCount = instances.length;
        Arrays.sort(this.mInstances);
    }

    @Override
    public InstanceIterator iterator(DateTime firstInstance) {
        return new InstanceIterator(){
            private int mNext;

            @Override
            public boolean hasNext() {
                return this.mNext < InstanceList.this.mCount;
            }

            @Override
            public long next() {
                if (this.mNext >= InstanceList.this.mCount) {
                    throw new ArrayIndexOutOfBoundsException("No more instances to iterate.");
                }
                return InstanceList.this.mInstances[this.mNext++];
            }

            @Override
            public void fastForward(long until) {
                int next;
                for (next = this.mNext; next < InstanceList.this.mCount && InstanceList.this.mInstances[next] < until; ++next) {
                }
                this.mNext = next;
            }
        };
    }
}

