/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.rfc5545.instanceiterator;

import java.util.NoSuchElementException;
import org.dmfs.rfc5545.DateTime;
import org.dmfs.rfc5545.InstanceIterator;

public final class PeekableInstanceIterator
implements InstanceIterator {
    private final InstanceIterator mDelegate;
    private DateTime mNext;
    private boolean mHasNext;

    public PeekableInstanceIterator(InstanceIterator delegate) {
        this.mDelegate = delegate;
        this.pullNext();
    }

    @Override
    public void fastForward(DateTime until) {
        if (this.mHasNext && this.mNext.before(until)) {
            this.mDelegate.fastForward(until);
            this.pullNext();
        }
    }

    @Override
    public boolean hasNext() {
        return this.mHasNext;
    }

    @Override
    public DateTime next() {
        if (!this.mHasNext) {
            throw new NoSuchElementException("no further elements to return");
        }
        DateTime result = this.mNext;
        this.pullNext();
        return result;
    }

    public DateTime peek() {
        if (!this.mHasNext) {
            throw new NoSuchElementException("no further elements to peek at");
        }
        return this.mNext;
    }

    private void pullNext() {
        this.mHasNext = this.mDelegate.hasNext();
        if (this.mHasNext) {
            this.mNext = (DateTime)this.mDelegate.next();
        }
    }
}

