/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.rfc5545.instanceiterator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.dmfs.jems2.iterable.Ascending;
import org.dmfs.jems2.iterable.Mapped;
import org.dmfs.jems2.iterable.Seq;
import org.dmfs.jems2.iterable.Sieved;
import org.dmfs.jems2.single.Collected;
import org.dmfs.rfc5545.DateTime;
import org.dmfs.rfc5545.InstanceIterator;

public final class Merged
implements InstanceIterator {
    private final List<IteratorHolder> mIteratorHolders;

    public Merged(InstanceIterator ... delegates) {
        this((Iterable<InstanceIterator>)new Seq((Object[])delegates));
    }

    public Merged(Iterable<InstanceIterator> delegates) {
        this.mIteratorHolders = (List)new Collected(ArrayList::new, (Iterable)new Ascending((Iterable)new Mapped(x$0 -> new IteratorHolder((InstanceIterator)x$0), (Iterable)new Sieved(Iterator::hasNext, delegates)))).value();
        for (int i = this.mIteratorHolders.size(); i > 1; --i) {
            if (!this.mIteratorHolders.get(i - 1).mNextValue.equals((Object)this.mIteratorHolders.get(i - 2).mNextValue)) continue;
            if (this.mIteratorHolders.get(i - 1).mIterator.hasNext()) {
                this.bubbleUp(i - 1);
                continue;
            }
            this.mIteratorHolders.remove(i - 1);
        }
    }

    @Override
    public boolean hasNext() {
        return this.mIteratorHolders.size() > 0;
    }

    @Override
    public DateTime next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No more elements to iterate");
        }
        DateTime result = this.mIteratorHolders.get(0).mNextValue;
        this.advance();
        return result;
    }

    @Override
    public void fastForward(DateTime until) {
        for (int i = this.mIteratorHolders.size() - 1; i >= 0; --i) {
            IteratorHolder it = this.mIteratorHolders.get(i);
            if (it.mNextValue.getTimestamp() >= until.getTimestamp()) continue;
            it.mIterator.fastForward(until);
            if (it.mIterator.hasNext()) {
                it.mNextValue = (DateTime)it.mIterator.next();
                continue;
            }
            this.mIteratorHolders.remove(i);
        }
        Collections.sort(this.mIteratorHolders);
    }

    private void advance() {
        if (this.mIteratorHolders.size() == 1) {
            IteratorHolder iteratorHolder = this.mIteratorHolders.get(0);
            if (iteratorHolder.mIterator.hasNext()) {
                iteratorHolder.mNextValue = (DateTime)iteratorHolder.mIterator.next();
            } else {
                this.mIteratorHolders.clear();
            }
        } else {
            IteratorHolder iteratorHolder = this.mIteratorHolders.get(0);
            if (iteratorHolder.mIterator.hasNext()) {
                this.bubbleUp(0);
            } else {
                this.mIteratorHolders.remove(0);
            }
        }
    }

    private void bubbleUp(int pos) {
        List<IteratorHolder> iteratorHolders = this.mIteratorHolders;
        IteratorHolder first = iteratorHolders.get(pos);
        DateTime next = (DateTime)first.mIterator.next();
        while (pos < iteratorHolders.size() - 1 && !next.before(iteratorHolders.get(pos + 1).mNextValue)) {
            if (next.equals((Object)iteratorHolders.get(pos + 1).mNextValue)) {
                if (first.mIterator.hasNext()) {
                    next = (DateTime)first.mIterator.next();
                } else {
                    iteratorHolders.remove(pos);
                    return;
                }
            }
            iteratorHolders.set(pos, iteratorHolders.get(pos + 1));
            ++pos;
        }
        first.mNextValue = next;
        iteratorHolders.set(pos, first);
    }

    private static final class IteratorHolder
    implements Comparable<IteratorHolder> {
        private DateTime mNextValue;
        private final InstanceIterator mIterator;

        private IteratorHolder(InstanceIterator iterator) {
            this((DateTime)iterator.next(), iterator);
        }

        private IteratorHolder(DateTime nextValue, InstanceIterator iterator) {
            this.mNextValue = nextValue;
            this.mIterator = iterator;
        }

        @Override
        public int compareTo(IteratorHolder o) {
            long diff = this.mNextValue.getTimestamp() - o.mNextValue.getTimestamp();
            return diff == 0L ? 0 : (diff < 0L ? -1 : 1);
        }
    }
}

