/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.rfc5545.instanceiterator;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.dmfs.rfc5545.DateTime;
import org.dmfs.rfc5545.InstanceIterator;

public final class FastForwardable
implements InstanceIterator {
    private DateTime mNextInstance;
    private final Iterator<DateTime> mDelegate;
    private boolean mHasNext = true;

    public FastForwardable(DateTime firstInstance, Iterator<DateTime> delegate) {
        this.mNextInstance = firstInstance;
        this.mDelegate = delegate;
    }

    @Override
    public void fastForward(DateTime until) {
        while (this.mHasNext && until.after(this.mNextInstance)) {
            this.moveToNext();
        }
    }

    @Override
    public boolean hasNext() {
        return this.mHasNext;
    }

    @Override
    public DateTime next() {
        if (!this.mHasNext) {
            throw new NoSuchElementException("No more elements to iterate");
        }
        DateTime next = this.mNextInstance;
        this.moveToNext();
        return next;
    }

    private void moveToNext() {
        if (this.mDelegate.hasNext()) {
            this.mNextInstance = this.mDelegate.next();
        } else {
            this.mHasNext = false;
        }
    }
}

