/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.rfc5545.instanceiterator;

import java.util.Locale;
import org.dmfs.rfc5545.DateTime;
import org.dmfs.rfc5545.InstanceIterator;

public final class EffectiveInstancesIterator
implements InstanceIterator {
    private static final DateTime MAX = new DateTime(131072, 11, 31, 23, 59, 59);
    private static final DateTime MIN = new DateTime(0, 0, 1, 0, 0, 0);
    private static final int MAX_SKIPPED_INSTANCES = 1000;
    private final InstanceIterator mInstances;
    private final InstanceIterator mExceptions;
    private DateTime mNextInstance = MIN;
    private DateTime mNextException = MIN;

    public EffectiveInstancesIterator(InstanceIterator instances, InstanceIterator exceptions) {
        this.mInstances = instances;
        this.mExceptions = exceptions;
        this.pullNext();
    }

    @Override
    public boolean hasNext() {
        return this.mNextInstance != MAX;
    }

    @Override
    public DateTime next() {
        if (!this.hasNext()) {
            throw new ArrayIndexOutOfBoundsException("no more elements");
        }
        DateTime result = this.mNextInstance;
        this.pullNext();
        return result;
    }

    @Override
    public void fastForward(DateTime until) {
        if (this.mNextInstance.before(until)) {
            this.mInstances.fastForward(until);
            this.mExceptions.fastForward(until);
            this.pullNext();
        }
    }

    private void pullNext() {
        DateTime next = MAX;
        DateTime nextException = this.mNextException;
        int skipableInstances = 1000;
        while (this.mInstances.hasNext()) {
            next = (DateTime)this.mInstances.next();
            while (nextException.before(next)) {
                nextException = this.mExceptions.hasNext() ? (DateTime)this.mExceptions.next() : MAX;
            }
            if (nextException.after(next)) break;
            if (--skipableInstances <= 0) {
                throw new RuntimeException(String.format(Locale.ENGLISH, "Skipped too many (%d) instances", 1000));
            }
            next = MAX;
        }
        this.mNextInstance = next;
        this.mNextException = nextException;
    }
}

