/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.rfc5545.instanceiterator;

import java.util.NoSuchElementException;
import org.dmfs.rfc5545.DateTime;
import org.dmfs.rfc5545.InstanceIterator;
import org.dmfs.rfc5545.recur.RecurrenceRuleIterator;

public final class CountLimitedRecurrenceRuleIterator
implements InstanceIterator {
    private final RecurrenceRuleIterator mDelegate;
    private int mRemaining;

    public CountLimitedRecurrenceRuleIterator(RecurrenceRuleIterator delegate, int remaining) {
        this.mDelegate = delegate;
        this.mRemaining = remaining;
    }

    @Override
    public boolean hasNext() {
        return this.mRemaining > 0 && this.mDelegate.hasNext();
    }

    @Override
    public DateTime next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No further elements to iterate");
        }
        --this.mRemaining;
        return this.mDelegate.nextDateTime();
    }

    @Override
    public void fastForward(DateTime until) {
        while (this.hasNext() && this.mDelegate.peekMillis() < until.getTimestamp()) {
            this.next();
        }
    }
}

