/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.rfc5545.recur;

import org.dmfs.rfc5545.Instance;
import org.dmfs.rfc5545.calendarmetrics.CalendarMetrics;
import org.dmfs.rfc5545.recur.ByExpander;
import org.dmfs.rfc5545.recur.RecurrenceRule;
import org.dmfs.rfc5545.recur.RuleIterator;
import org.dmfs.rfc5545.recur.StaticUtils;

final class ByYearDayWeeklyExpander
extends ByExpander {
    private final int[] mYearDays;

    public ByYearDayWeeklyExpander(RecurrenceRule rule, RuleIterator previous, CalendarMetrics calendarMetrics, long start) {
        super(previous, calendarMetrics, start);
        this.mYearDays = StaticUtils.ListToSortedArray(rule.getByPart(RecurrenceRule.Part.BYYEARDAY));
    }

    @Override
    void expand(long instance, long start) {
        int year = Instance.year((long)instance);
        int month = Instance.month((long)instance);
        int dayOfMonth = Instance.dayOfMonth((long)instance);
        int hour = Instance.hour((long)instance);
        int minute = Instance.minute((long)instance);
        int second = Instance.second((long)instance);
        int yearDays = this.mCalendarMetrics.getDaysPerYear(year);
        int[] nArray = this.mYearDays;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int monthAndDay;
            int day;
            int actualDay = day = nArray[i];
            if (day < 0) {
                actualDay = day + yearDays + 1;
            }
            int prevYearDays = this.mCalendarMetrics.getDaysPerYear(year - 1);
            int nextYearDays = this.mCalendarMetrics.getDaysPerYear(year + 1);
            int prevYearDay = day;
            int nextYearDay = day;
            if (day < 0) {
                prevYearDay = day + prevYearDays + 1;
                nextYearDay = day + nextYearDays + 1;
            }
            int oldWeek = this.mCalendarMetrics.getWeekOfYear(year, month, dayOfMonth);
            int newWeek = this.mCalendarMetrics.getWeekOfYear(year, actualDay);
            if (0 < actualDay && actualDay <= yearDays && newWeek == oldWeek) {
                monthAndDay = this.mCalendarMetrics.getMonthAndDayOfYearDay(year, actualDay);
                this.addInstance(Instance.setMonthAndDayOfMonth((long)instance, (int)CalendarMetrics.packedMonth((int)monthAndDay), (int)CalendarMetrics.dayOfMonth((int)monthAndDay)));
                continue;
            }
            if (0 < nextYearDay && nextYearDay <= nextYearDays && nextYearDay < 7) {
                newWeek = this.mCalendarMetrics.getWeekOfYear(year + 1, nextYearDay);
                if (newWeek != oldWeek) continue;
                monthAndDay = this.mCalendarMetrics.getMonthAndDayOfYearDay(year + 1, nextYearDay);
                this.addInstance(Instance.make((int)(year + 1), (int)CalendarMetrics.packedMonth((int)monthAndDay), (int)CalendarMetrics.dayOfMonth((int)monthAndDay), (int)hour, (int)minute, (int)second));
                continue;
            }
            if (0 >= prevYearDay || prevYearDay > prevYearDays || prevYearDay <= prevYearDays - 7 || (newWeek = this.mCalendarMetrics.getWeekOfYear(year - 1, prevYearDay)) != oldWeek) continue;
            monthAndDay = this.mCalendarMetrics.getMonthAndDayOfYearDay(year - 1, prevYearDay);
            this.addInstance(Instance.make((int)(year - 1), (int)CalendarMetrics.packedMonth((int)monthAndDay), (int)CalendarMetrics.dayOfMonth((int)monthAndDay), (int)hour, (int)minute, (int)second));
        }
    }
}

