/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.rfc5545.recur;

import org.dmfs.rfc5545.Instance;
import org.dmfs.rfc5545.calendarmetrics.CalendarMetrics;
import org.dmfs.rfc5545.recur.ByExpander;
import org.dmfs.rfc5545.recur.RecurrenceRule;
import org.dmfs.rfc5545.recur.RuleIterator;
import org.dmfs.rfc5545.recur.StaticUtils;

final class ByWeekNoMonthlyOverlapExpander
extends ByExpander {
    private final int[] mByWeekNo;
    private final int mOriginalWeekDay;

    public ByWeekNoMonthlyOverlapExpander(RecurrenceRule rule, RuleIterator previous, CalendarMetrics calendarTools, long start) {
        super(previous, calendarTools, start);
        this.mByWeekNo = StaticUtils.ListToSortedArray(rule.getByPart(RecurrenceRule.Part.BYWEEKNO));
        this.mOriginalWeekDay = calendarTools.getDayOfWeek(Instance.year((long)start), Instance.month((long)start), Instance.dayOfMonth((long)start));
    }

    @Override
    void expand(long instance, long notBefore) {
        int year = Instance.year((long)instance);
        int month = Instance.month((long)instance);
        int hour = Instance.hour((long)instance);
        int minute = Instance.minute((long)instance);
        int second = Instance.second((long)instance);
        int yearWeeks = this.mCalendarMetrics.getWeeksPerYear(year);
        int[] nArray = this.mByWeekNo;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int monthAndDay3;
            int newMonth3;
            int weekOfYear;
            int actualWeek = weekOfYear = nArray[i];
            if (weekOfYear < 0) {
                actualWeek = yearWeeks + weekOfYear + 1;
            }
            if (actualWeek <= 0 || actualWeek > yearWeeks) continue;
            int yearDay = this.mCalendarMetrics.getYearDayOfIsoYear(year, actualWeek, this.mOriginalWeekDay);
            int monthAndDay = this.mCalendarMetrics.getMonthAndDayOfYearDay(year, yearDay);
            int newMonth = CalendarMetrics.packedMonth((int)monthAndDay);
            if (newMonth == month) {
                this.addInstance(Instance.make((int)year, (int)newMonth, (int)CalendarMetrics.dayOfMonth((int)monthAndDay), (int)hour, (int)minute, (int)second));
                continue;
            }
            int firstDayOfWeek = this.mCalendarMetrics.weekStartInt;
            int yearDay2 = this.mCalendarMetrics.getYearDayOfIsoYear(year, actualWeek, firstDayOfWeek);
            if (yearDay2 < 1 || yearDay2 > this.mCalendarMetrics.getDaysPerYear(year)) continue;
            int monthAndDay2 = this.mCalendarMetrics.getMonthAndDayOfYearDay(year, yearDay2);
            int newMonth2 = CalendarMetrics.packedMonth((int)monthAndDay2);
            if (newMonth2 == month) {
                int offset = (this.mOriginalWeekDay - firstDayOfWeek + 7) % 7;
                this.addInstance(Instance.make((int)year, (int)month, (int)(CalendarMetrics.dayOfMonth((int)monthAndDay2) + offset), (int)hour, (int)minute, (int)second));
                continue;
            }
            int yearDay3 = this.mCalendarMetrics.getYearDayOfIsoYear(year, actualWeek, (firstDayOfWeek + 6) % 7);
            if (yearDay3 < 1 || yearDay3 > this.mCalendarMetrics.getDaysPerYear(year) || (newMonth3 = CalendarMetrics.packedMonth((int)(monthAndDay3 = this.mCalendarMetrics.getMonthAndDayOfYearDay(year, yearDay3)))) != month) continue;
            int offset = (this.mOriginalWeekDay - firstDayOfWeek - 6) % 7;
            this.addInstance(Instance.make((int)year, (int)month, (int)(CalendarMetrics.dayOfMonth((int)monthAndDay3) + offset), (int)hour, (int)minute, (int)second));
        }
    }
}

