/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.rfc5545.recur;

import org.dmfs.rfc5545.Instance;
import org.dmfs.rfc5545.calendarmetrics.CalendarMetrics;
import org.dmfs.rfc5545.recur.ByFilter;
import org.dmfs.rfc5545.recur.RecurrenceRule;
import org.dmfs.rfc5545.recur.StaticUtils;

final class ByMonthFilter
implements ByFilter {
    private final int[] mMonths;
    private final CalendarMetrics mCalendarMetrics;

    public ByMonthFilter(RecurrenceRule rule, CalendarMetrics calendarMetrics) {
        this.mCalendarMetrics = calendarMetrics;
        this.mMonths = StaticUtils.ListToArray(rule.getByPart(RecurrenceRule.Part.BYMONTH));
    }

    @Override
    public boolean filter(long instance) {
        int month = Instance.month((long)instance);
        int[] months = this.mMonths;
        CalendarMetrics calendarMetrics = this.mCalendarMetrics;
        if (StaticUtils.linearSearch(months, month) >= 0) {
            return false;
        }
        long startOfWeek = calendarMetrics.startOfWeek(instance);
        if (StaticUtils.linearSearch(months, Instance.month((long)startOfWeek)) >= 0) {
            return false;
        }
        long endOfWeek = calendarMetrics.nextDay(startOfWeek, 6);
        return StaticUtils.linearSearch(months, Instance.month((long)endOfWeek)) < 0;
    }
}

