/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.rfc5545.recur;

import org.dmfs.rfc5545.Instance;
import org.dmfs.rfc5545.recur.LongArray;
import org.dmfs.rfc5545.recur.RecurrenceRule;
import org.dmfs.rfc5545.recur.RuleIterator;
import org.dmfs.rfc5545.recur.StaticUtils;

final class BySetPosFilter
extends RuleIterator {
    private static final int MAX_EMPTY_SETS = 1000;
    private final int[] mSetPositions;
    private LongArray mSetIterator;
    private final LongArray mResultSet = new LongArray();
    private final long mStart;

    public BySetPosFilter(RecurrenceRule rule, RuleIterator previous, long start) {
        super(previous);
        this.mSetPositions = StaticUtils.ListToSortedArray(rule.getByPart(RecurrenceRule.Part.BYSETPOS));
        this.mStart = start - 1L;
    }

    @Override
    public long next() {
        if (this.mSetIterator == null || !this.mSetIterator.hasNext()) {
            this.mSetIterator = this.nextSet();
        }
        return this.mSetIterator.next();
    }

    @Override
    LongArray nextSet() {
        LongArray resultSet = this.mResultSet;
        int[] setPositions = this.mSetPositions;
        resultSet.clear();
        boolean done = false;
        int counter = -1;
        do {
            if (++counter == 1000) {
                throw new IllegalStateException("too many empty recurrence sets");
            }
            LongArray nextSet = this.mPrevious.nextSet();
            int limit = nextSet.size() + 1;
            int pos = 1;
            while (nextSet.hasNext()) {
                long d = nextSet.next();
                if ((StaticUtils.linearSearch(setPositions, pos) >= 0 || pos < limit && StaticUtils.linearSearch(setPositions, pos - limit) >= 0) && this.mStart < Instance.maskWeekday((long)d)) {
                    resultSet.add(d);
                    done = true;
                }
                ++pos;
            }
        } while (!done);
        return resultSet;
    }
}

