/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.rfc5545.recur;

import java.util.List;
import org.dmfs.rfc5545.Instance;
import org.dmfs.rfc5545.calendarmetrics.CalendarMetrics;
import org.dmfs.rfc5545.recur.ByExpander;
import org.dmfs.rfc5545.recur.RecurrenceRule;
import org.dmfs.rfc5545.recur.RuleIterator;
import org.dmfs.rfc5545.recur.StaticUtils;

final class ByDayWeeklyAndMonthlyExpander
extends ByExpander {
    private final int mDayBitMap;
    private final int[] mMonths;

    public ByDayWeeklyAndMonthlyExpander(RecurrenceRule rule, RuleIterator previous, CalendarMetrics calendarTools, long start) {
        super(previous, calendarTools, start);
        List<RecurrenceRule.WeekdayNum> byDay = rule.getByDayPart();
        int dayBitMap = 0;
        for (RecurrenceRule.WeekdayNum weekdayNum : byDay) {
            if (weekdayNum.pos != 0) continue;
            dayBitMap |= 1 << weekdayNum.weekday.ordinal();
        }
        this.mDayBitMap = dayBitMap;
        this.mMonths = (int[])(rule.hasPart(RecurrenceRule.Part.BYMONTH) ? StaticUtils.ListToArray(rule.getByPart(RecurrenceRule.Part.BYMONTH)) : null);
    }

    @Override
    void expand(long instance, long start) {
        CalendarMetrics calendarMetrics = this.mCalendarMetrics;
        int month = Instance.month((long)instance);
        int dayBitMap = this.mDayBitMap;
        int day = 0;
        while (dayBitMap > 0) {
            while ((dayBitMap & 1) == 0) {
                dayBitMap >>= 1;
                ++day;
            }
            long newInstance = calendarMetrics.setDayOfWeek(instance, day);
            int newMonth = Instance.month((long)newInstance);
            if (this.mMonths != null && StaticUtils.linearSearch(this.mMonths, newMonth) >= 0 || this.mMonths == null && newMonth == month) {
                this.addInstance(newInstance);
            }
            dayBitMap >>= 1;
            ++day;
        }
    }
}

