/*
 * Copyright (C) 2013 Marten Gajda <marten@dmfs.org>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

package org.dmfs.rfc5545.recur;

/**
 * An Exception that indicates an error in a recurrence rule.
 *
 * @author Marten Gajda
 */
public class InvalidRecurrenceRuleException extends Exception
{

    /**
     * Generated serial id.
     */
    private static final long serialVersionUID = 2282570760598972553L;


    public InvalidRecurrenceRuleException(String msg)
    {
        super(msg);
    }


    public InvalidRecurrenceRuleException(String msg, Throwable e)
    {
        super(msg, e);
    }
}
