/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.rfc5545.recur;

import java.util.List;
import org.dmfs.rfc5545.Instance;
import org.dmfs.rfc5545.calendarmetrics.CalendarMetrics;
import org.dmfs.rfc5545.recur.ByExpander;
import org.dmfs.rfc5545.recur.Freq;
import org.dmfs.rfc5545.recur.LongArray;
import org.dmfs.rfc5545.recur.RecurrenceRule;

public final class FastBirthdayIterator
extends ByExpander {
    private final int mInterval;
    private final LongArray mResultSet = new LongArray(1);
    private long mNextInstance;

    private FastBirthdayIterator(RecurrenceRule rule, CalendarMetrics calendarMetrics, long firstInstance) {
        super(null, calendarMetrics, firstInstance);
        int interval = rule.getInterval();
        this.mInterval = rule.getFreq() == Freq.MONTHLY ? (interval > 12 ? interval / 12 : 1) : interval;
        this.mNextInstance = firstInstance;
    }

    public static FastBirthdayIterator getInstance(RecurrenceRule rule, CalendarMetrics calendarMetrics, long start) {
        int interval;
        if (rule.hasPart(RecurrenceRule.Part.BYDAY) || rule.hasPart(RecurrenceRule.Part.BYYEARDAY) || rule.hasPart(RecurrenceRule.Part.BYWEEKNO) || rule.hasPart(RecurrenceRule.Part.BYHOUR) || rule.hasPart(RecurrenceRule.Part.BYMINUTE) || rule.hasPart(RecurrenceRule.Part.BYSECOND) || rule.hasPart(RecurrenceRule.Part.BYSETPOS) || rule.getSkip() != RecurrenceRule.Skip.OMIT) {
            return null;
        }
        Freq freq = rule.getFreq();
        List<Integer> months = rule.getByPart(RecurrenceRule.Part.BYMONTH);
        List<Integer> days = rule.getByPart(RecurrenceRule.Part.BYMONTHDAY);
        if (freq == Freq.MONTHLY && ((interval = rule.getInterval()) == 5 || interval > 6 && interval % 12 != 0)) {
            return null;
        }
        if (months != null && months.size() == 1 && (days == null && (freq == Freq.MONTHLY || freq == Freq.YEARLY) || days != null && days.size() == 1 && days.get(0) > 0 && (freq == Freq.MONTHLY || freq == Freq.YEARLY || freq == Freq.DAILY)) || freq == Freq.YEARLY && months == null && days == null) {
            if (months != null) {
                start = Instance.setMonth((long)start, (int)months.get(0));
            }
            if (days != null) {
                start = Instance.setDayOfMonth((long)start, (int)days.get(0));
            }
            return new FastBirthdayIterator(rule, calendarMetrics, start);
        }
        return null;
    }

    @Override
    public long next() {
        long result = this.mNextInstance;
        this.mNextInstance = Instance.setYear((long)this.mNextInstance, (int)(Instance.year((long)this.mNextInstance) + this.mInterval));
        return result;
    }

    @Override
    LongArray nextSet() {
        this.mResultSet.clear();
        this.mResultSet.add(this.next());
        return this.mResultSet;
    }

    @Override
    void expand(long instance, long start) {
    }

    @Override
    void fastForward(long untilInstance) {
        int untilYear = Instance.year((long)untilInstance);
        int nextYear = Instance.year((long)this.mNextInstance);
        this.mNextInstance = Instance.setYear((long)this.mNextInstance, (int)(nextYear + Math.max(0, untilYear - nextYear) % this.mInterval * this.mInterval));
    }
}

