/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.rfc5545.recur;

import org.dmfs.rfc5545.Instance;
import org.dmfs.rfc5545.calendarmetrics.CalendarMetrics;
import org.dmfs.rfc5545.recur.ByFilter;
import org.dmfs.rfc5545.recur.RecurrenceRule;
import org.dmfs.rfc5545.recur.StaticUtils;

final class ByWeekNoFilter
implements ByFilter {
    private final int[] mWeekNumbers;
    final CalendarMetrics mCalendarMetrics;

    public ByWeekNoFilter(RecurrenceRule rule, CalendarMetrics calendarMetrics) {
        this.mCalendarMetrics = calendarMetrics;
        this.mWeekNumbers = StaticUtils.ListToSortedArray(rule.getByPart(RecurrenceRule.Part.BYWEEKNO));
    }

    @Override
    public boolean filter(long instance) {
        int year = Instance.year((long)instance);
        int week = this.mCalendarMetrics.getWeekOfYear(year, Instance.month((long)instance), Instance.dayOfMonth((long)instance));
        int weeks = week > 10 && Instance.month((long)instance) == 1 ? this.mCalendarMetrics.getWeeksPerYear(year - 1) : (week == 1 && Instance.month((long)instance) > 1 ? this.mCalendarMetrics.getWeeksPerYear(year + 1) : this.mCalendarMetrics.getWeeksPerYear(year));
        return StaticUtils.linearSearch(this.mWeekNumbers, week) < 0 && StaticUtils.linearSearch(this.mWeekNumbers, week - 1 - weeks) < 0 || week > weeks;
    }
}

