/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.rfc5545.recur;

import java.util.List;
import org.dmfs.rfc5545.calendarmetrics.CalendarMetrics;
import org.dmfs.rfc5545.recur.ByExpander;
import org.dmfs.rfc5545.recur.RecurrenceRule;
import org.dmfs.rfc5545.recur.RuleIterator;

final class ByDayWeeklyExpander
extends ByExpander {
    private final int mDayBitMap;

    public ByDayWeeklyExpander(RecurrenceRule rule, RuleIterator previous, CalendarMetrics calendarTools, long start) {
        super(previous, calendarTools, start);
        List<RecurrenceRule.WeekdayNum> byDay = rule.getByDayPart();
        int dayBitMap = 0;
        for (RecurrenceRule.WeekdayNum weekdayNum : byDay) {
            if (weekdayNum.pos != 0) continue;
            dayBitMap |= 1 << weekdayNum.weekday.ordinal();
        }
        this.mDayBitMap = dayBitMap;
    }

    @Override
    void expand(long instance, long start) {
        CalendarMetrics calendarMetrics = this.mCalendarMetrics;
        int dayBitMap = this.mDayBitMap;
        int day = 0;
        while (dayBitMap > 0) {
            while ((dayBitMap & 1) == 0) {
                dayBitMap >>= 1;
                ++day;
            }
            this.addInstance(calendarMetrics.setDayOfWeek(instance, day));
            dayBitMap >>= 1;
            ++day;
        }
    }
}

