/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.rfc5545.recurrenceset;

import java.util.TimeZone;
import org.dmfs.rfc5545.recur.RecurrenceRule;
import org.dmfs.rfc5545.recur.RecurrenceRuleIterator;
import org.dmfs.rfc5545.recurrenceset.AbstractRecurrenceAdapter;
import org.dmfs.rfc5545.recurrenceset.CountLimitedRecurrenceRuleIterator;

public final class RecurrenceRuleAdapter
extends AbstractRecurrenceAdapter {
    private final RecurrenceRule mRrule;

    public RecurrenceRuleAdapter(RecurrenceRule rule) {
        this.mRrule = rule;
    }

    @Override
    AbstractRecurrenceAdapter.InstanceIterator getIterator(TimeZone timezone, long start) {
        AbstractRecurrenceAdapter.InstanceIterator iterator = new InstanceIterator(this.mRrule.iterator(start, timezone));
        if (this.mRrule.getCount() != null && iterator.peek() != start) {
            iterator = new CountLimitedRecurrenceRuleIterator(iterator, this.mRrule.getCount() - 1);
        }
        return iterator;
    }

    @Override
    boolean isInfinite() {
        return this.mRrule.isInfinite();
    }

    @Override
    long getLastInstance(TimeZone timezone, long start) {
        if (this.isInfinite()) {
            return Long.MAX_VALUE;
        }
        RecurrenceRuleIterator iterator = this.mRrule.iterator(start, timezone);
        iterator.skipAllButLast();
        long lastInstance = Long.MIN_VALUE;
        if (iterator.hasNext()) {
            lastInstance = iterator.nextMillis();
        }
        return lastInstance;
    }

    class InstanceIterator
    implements AbstractRecurrenceAdapter.InstanceIterator {
        private final RecurrenceRuleIterator mIterator;

        public InstanceIterator(RecurrenceRuleIterator iterator) {
            this.mIterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.mIterator.hasNext();
        }

        @Override
        public long next() {
            return this.mIterator.nextMillis();
        }

        @Override
        public long peek() {
            return this.mIterator.peekMillis();
        }

        @Override
        public void skip(int count) {
            this.mIterator.skip(count);
        }

        @Override
        public void fastForward(long until) {
            this.mIterator.fastForward(until);
        }
    }
}

