/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.rfc5545.recurrenceset;

import java.util.Arrays;
import java.util.TimeZone;
import org.dmfs.rfc5545.DateTime;
import org.dmfs.rfc5545.calendarmetrics.CalendarMetrics;
import org.dmfs.rfc5545.recurrenceset.AbstractRecurrenceAdapter;

public final class RecurrenceList
extends AbstractRecurrenceAdapter {
    private final long[] mInstances;
    private final int mCount;

    public RecurrenceList(String list, TimeZone timeZone) {
        this(DateTime.GREGORIAN_CALENDAR_SCALE, list, timeZone);
    }

    public RecurrenceList(CalendarMetrics calendarMetrics, String list, TimeZone timeZone) {
        if (list == null || list.length() == 0) {
            this.mInstances = null;
            this.mCount = 0;
            return;
        }
        String[] instances = list.split(",");
        this.mInstances = new long[instances.length];
        int count = 0;
        for (String instanceString : instances) {
            DateTime instance = DateTime.parse((CalendarMetrics)calendarMetrics, (TimeZone)timeZone, (String)instanceString);
            this.mInstances[count] = instance.getTimestamp();
            ++count;
        }
        this.mCount = count;
        Arrays.sort(this.mInstances);
    }

    public RecurrenceList(long[] instances) {
        this.mInstances = new long[instances.length];
        System.arraycopy(instances, 0, this.mInstances, 0, instances.length);
        this.mCount = instances.length;
        Arrays.sort(this.mInstances);
    }

    @Override
    InstanceIterator getIterator(TimeZone timezone, long start) {
        return new InstanceIterator(start);
    }

    @Override
    boolean isInfinite() {
        return false;
    }

    @Override
    long getLastInstance(TimeZone timezone, long start) {
        long[] instances = this.mInstances;
        return instances[instances.length - 1];
    }

    class InstanceIterator
    implements AbstractRecurrenceAdapter.InstanceIterator {
        private int mNext;

        public InstanceIterator(long start) {
            this.fastForward(start);
        }

        @Override
        public boolean hasNext() {
            return this.mNext < RecurrenceList.this.mCount;
        }

        @Override
        public long next() {
            if (this.mNext >= RecurrenceList.this.mCount) {
                throw new ArrayIndexOutOfBoundsException("No more instances to iterate.");
            }
            return RecurrenceList.this.mInstances[this.mNext++];
        }

        @Override
        public long peek() {
            if (this.mNext >= RecurrenceList.this.mCount) {
                throw new ArrayIndexOutOfBoundsException("No more instances to iterate.");
            }
            return RecurrenceList.this.mInstances[this.mNext];
        }

        @Override
        public void skip(int count) {
            this.mNext += count;
        }

        @Override
        public void fastForward(long until) {
            int next;
            int count = RecurrenceList.this.mCount;
            long[] instances = RecurrenceList.this.mInstances;
            for (next = this.mNext; next < count && instances[next] < until; ++next) {
            }
            this.mNext = next;
        }
    }
}

