/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.rfc5545.recur;

import org.dmfs.rfc5545.Instance;
import org.dmfs.rfc5545.calendarmetrics.CalendarMetrics;
import org.dmfs.rfc5545.recur.LongArray;
import org.dmfs.rfc5545.recur.RuleIterator;

final class SanityFilter
extends RuleIterator {
    private static final int MAX_EMPTY_SETS = 1000;
    private static final int MAX_FILTERED_INSTANCES = 1000;
    private final LongArray mResultSet = new LongArray();
    private final CalendarMetrics mCalendarMetrics;
    private long mLastResult;

    SanityFilter(RuleIterator previous, CalendarMetrics calendarTools, long start) {
        super(previous);
        this.mCalendarMetrics = calendarTools;
        this.mLastResult = start - 1L;
    }

    @Override
    public long next() {
        long next;
        long simpleInstance;
        CalendarMetrics calendarMetrics = this.mCalendarMetrics;
        int counter = -1;
        long last = this.mLastResult;
        do {
            if (++counter != 1000) continue;
            throw new IllegalArgumentException("too many filtered recurrence instances");
        } while (last >= (simpleInstance = Instance.maskWeekday((long)(next = this.mPrevious.next()))) || !calendarMetrics.validate(simpleInstance));
        this.mLastResult = simpleInstance;
        return next;
    }

    @Override
    LongArray nextSet() {
        LongArray resultSet = this.mResultSet;
        long last = Long.MIN_VALUE;
        CalendarMetrics calendarMetrics = this.mCalendarMetrics;
        resultSet.clear();
        int counter = 0;
        do {
            if (counter == 1000) {
                throw new IllegalArgumentException("too many empty recurrence sets");
            }
            ++counter;
            LongArray prev = this.mPrevious.nextSet();
            long simpleInstance = 0L;
            while (prev.hasNext()) {
                long next = prev.next();
                simpleInstance = Instance.maskWeekday((long)next);
                if (last >= simpleInstance || !calendarMetrics.validate(simpleInstance)) continue;
                resultSet.add(next);
                last = simpleInstance;
            }
        } while (!resultSet.hasNext());
        return resultSet;
    }
}

