/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.jems2.generator;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Locale;
import org.dmfs.jems2.Generator;
import org.dmfs.jems2.Single;

public final class DigestGenerator
implements Generator<MessageDigest> {
    private final Single<String> mAlgorithm;

    public DigestGenerator(String algorithm) {
        this(() -> algorithm);
    }

    public DigestGenerator(Single<String> algorithm) {
        this.mAlgorithm = algorithm;
    }

    @Override
    public MessageDigest next() throws RuntimeException {
        try {
            return MessageDigest.getInstance(this.mAlgorithm.value());
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(String.format(Locale.ENGLISH, "Algorithm %s not supported by runtime.", this.mAlgorithm.value()), e);
        }
    }
}

