/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.jems2.charsequence;

import org.dmfs.jems2.Single;
import org.dmfs.jems2.single.Frozen;

public final class Grouped
implements CharSequence {
    private final CharSequence mDelegate;
    private final int mGroupSize;
    private final char mSeparator;
    private final Single<String> mToString;

    public Grouped(int groupSize, char separator, CharSequence delegate) {
        this.mDelegate = delegate;
        this.mGroupSize = groupSize;
        this.mSeparator = separator;
        this.mToString = new Frozen<String>(() -> {
            int len = delegate.length();
            StringBuilder stringBuilder = new StringBuilder(this.length());
            int i = 0;
            while (i < len) {
                stringBuilder.append(delegate.charAt(i++));
                if (i >= len || i % groupSize != 0) continue;
                stringBuilder.append(separator);
            }
            return stringBuilder.toString();
        });
    }

    @Override
    public int length() {
        int delegateLength = this.mDelegate.length();
        return delegateLength + Math.max(0, (delegateLength + this.mGroupSize - 1) / this.mGroupSize - 1);
    }

    @Override
    public char charAt(int i) {
        if (i < 0 || i >= this.length()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int group = i / (this.mGroupSize + 1);
        return (i + 1) % (this.mGroupSize + 1) == 0 ? this.mSeparator : this.mDelegate.charAt(i - group);
    }

    @Override
    public CharSequence subSequence(int i, int i1) {
        return this.toString().subSequence(i, i1);
    }

    @Override
    public String toString() {
        return this.mToString.value();
    }
}

