/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.jems.stack.elementary;

import java.util.NoSuchElementException;
import org.dmfs.jems.optional.Optional;
import org.dmfs.jems.single.Single;
import org.dmfs.jems.single.elementary.ValueSingle;
import org.dmfs.jems.stack.Stack;
import org.dmfs.jems.stack.elementary.EmptyStack;

public final class SingleStack<Element>
implements Stack<Element> {
    private final Optional<Stack.StackTop<Element>> mStackTop;

    public SingleStack(Element value) {
        this((Single<Element>)new ValueSingle<Element>(value));
    }

    public SingleStack(Single<Element> value) {
        this(new PresentStackTop(value));
    }

    private SingleStack(Optional<Stack.StackTop<Element>> stackTop) {
        this.mStackTop = stackTop;
    }

    @Override
    public Optional<Stack.StackTop<Element>> top() {
        return this.mStackTop;
    }

    private static final class PresentStackTop<Element>
    implements Optional<Stack.StackTop<Element>>,
    Stack.StackTop<Element> {
        private final Single<Element> mElement;

        private PresentStackTop(Single<Element> element) {
            this.mElement = element;
        }

        @Override
        public boolean isPresent() {
            return true;
        }

        @Override
        public Stack.StackTop<Element> value() throws NoSuchElementException {
            return this;
        }

        @Override
        public Element element() {
            return this.mElement.value();
        }

        @Override
        public Stack<Element> bottom() {
            return new EmptyStack();
        }
    }
}

