/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.jems.single.elementary;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.util.Locale;
import org.dmfs.jems.function.BiFunction;
import org.dmfs.jems.generator.Generator;
import org.dmfs.jems.iterable.decorators.Mapped;
import org.dmfs.jems.iterable.elementary.Seq;
import org.dmfs.jems.messagedigest.MessageDigestFactory;
import org.dmfs.jems.single.Single;
import org.dmfs.jems.single.elementary.Reduced;
import org.dmfs.jems.single.elementary.ValueSingle;

public final class Digest
implements Single<byte[]> {
    private final Generator<MessageDigest> mMessageDigestGenerator;
    private final Iterable<Single<byte[]>> mParts;

    public Digest(MessageDigestFactory messageDigestFactory, byte[] ... parts) {
        this(messageDigestFactory, new Mapped(part -> () -> part, new Seq((T[])parts)));
    }

    public Digest(MessageDigestFactory messageDigestFactory, CharSequence ... parts) {
        this(messageDigestFactory, "UTF-8", parts);
    }

    public Digest(MessageDigestFactory messageDigestFactory, String encoding, CharSequence ... parts) {
        this(messageDigestFactory, new Mapped(bytes -> {
            try {
                return new ValueSingle<byte[]>(bytes.toString().getBytes(encoding));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(String.format(Locale.ENGLISH, "%s encoding not supported by runtime", encoding), e);
            }
        }, new Seq<CharSequence>(parts)));
    }

    @SafeVarargs
    public Digest(MessageDigestFactory messageDigestFactory, Single<byte[]> ... parts) {
        this(messageDigestFactory, new Seq<Single<byte[]>>(parts));
    }

    public Digest(MessageDigestFactory messageDigestFactory, Iterable<Single<byte[]>> parts) {
        this(messageDigestFactory::newInstance, parts);
    }

    public Digest(Generator<MessageDigest> messageDigestGenerator, byte[] ... parts) {
        this(messageDigestGenerator, new Mapped(part -> () -> part, new Seq((T[])parts)));
    }

    public Digest(Generator<MessageDigest> messageDigestGenerator, CharSequence ... parts) {
        this(messageDigestGenerator, "UTF-8", parts);
    }

    public Digest(Generator<MessageDigest> messageDigestGenerator, String encoding, CharSequence ... parts) {
        this(messageDigestGenerator, new Mapped(bytes -> {
            try {
                return new ValueSingle<byte[]>(bytes.toString().getBytes(encoding));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(String.format(Locale.ENGLISH, "%s encoding not supported by runtime", encoding), e);
            }
        }, new Seq<CharSequence>(parts)));
    }

    @SafeVarargs
    public Digest(Generator<MessageDigest> messageDigestGenerator, Single<byte[]> ... parts) {
        this(messageDigestGenerator, new Seq<Single<byte[]>>(parts));
    }

    public Digest(Generator<MessageDigest> messageDigestGenerator, Iterable<Single<byte[]>> parts) {
        this.mMessageDigestGenerator = messageDigestGenerator;
        this.mParts = parts;
    }

    @Override
    public byte[] value() {
        return new Reduced<Single<byte[]>, MessageDigest>(this.mMessageDigestGenerator, new DigestFunction(), this.mParts).value().digest();
    }

    private static final class DigestFunction
    implements BiFunction<MessageDigest, Single<byte[]>, MessageDigest> {
        private DigestFunction() {
        }

        @Override
        public MessageDigest value(MessageDigest messageDigest, Single<byte[]> bytes) {
            messageDigest.update(bytes.value());
            return messageDigest;
        }
    }
}

