/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.jems.single.adapters;

import org.dmfs.jems.fragile.Fragile;
import org.dmfs.jems.function.Function;
import org.dmfs.jems.single.Single;

public final class Unchecked<T, E extends Exception>
implements Single<T> {
    private final Fragile<T, E> mDelegate;
    private final Function<Exception, ? extends RuntimeException> mExceptionFactory;

    public Unchecked(Fragile<T, E> delegate) {
        this("Broken fragile delegate", delegate);
    }

    public Unchecked(String message, Fragile<T, E> delegate) {
        this(e -> new RuntimeException(message, (Throwable)e), delegate);
    }

    public Unchecked(Function<Exception, ? extends RuntimeException> exceptionFactory, Fragile<T, E> delegate) {
        this.mDelegate = delegate;
        this.mExceptionFactory = exceptionFactory;
    }

    @Override
    public T value() {
        try {
            return this.mDelegate.value();
        }
        catch (Exception e) {
            throw (RuntimeException)this.mExceptionFactory.value(e);
        }
    }
}

