/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.jems.iterable.decorators;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.dmfs.iterators.AbstractBaseIterator;
import org.dmfs.jems.generator.Generator;

public final class Frozen<T>
implements Iterable<T> {
    private Generator<Iterator<T>> mIteratorGenerator;

    public Frozen(Iterator<T> delegate) {
        this(() -> delegate);
    }

    public Frozen(final Iterable<T> delegate) {
        this.mIteratorGenerator = new Generator<Iterator<T>>(){
            private final List<T> mCache = new ArrayList(64);
            private final Iterator<T> mIterator = delegate.iterator();

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Iterator<T> next() {
                Iterator iterator = this.mIterator;
                synchronized (iterator) {
                    if (this.mIterator.hasNext()) {
                        return new SynchronizedCachingIterator(this.mIterator, this.mCache, this.mCache.size());
                    }
                    Frozen.this.mIteratorGenerator = () -> new ListIterator(this.mCache);
                }
                return new ListIterator(this.mCache);
            }
        };
    }

    @Override
    public Iterator<T> iterator() {
        return this.mIteratorGenerator.next();
    }

    private static final class SynchronizedCachingIterator<T>
    extends AbstractBaseIterator<T> {
        private final Iterator<T> mOriginalIterator;
        private final List<T> mCache;
        private int mSafeElements;
        private int mPos;

        public SynchronizedCachingIterator(Iterator<T> originalIterator, List<T> cache, int safeElements) {
            this.mOriginalIterator = originalIterator;
            this.mCache = cache;
            this.mSafeElements = safeElements;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasNext() {
            if (this.mPos < this.mSafeElements) {
                return true;
            }
            Iterator<T> iterator = this.mOriginalIterator;
            synchronized (iterator) {
                this.mSafeElements = this.mCache.size();
                return this.mPos < this.mSafeElements || this.mOriginalIterator.hasNext();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T next() {
            Iterator<T> iterator = this.mOriginalIterator;
            synchronized (iterator) {
                if (this.mPos == this.mCache.size()) {
                    T next = this.mOriginalIterator.next();
                    this.mCache.add(next);
                    ++this.mPos;
                    return next;
                }
                return this.mCache.get(this.mPos++);
            }
        }
    }

    private static final class ListIterator<T>
    extends AbstractBaseIterator<T> {
        private final List<T> mList;
        private int mPos;

        private ListIterator(List<T> list) {
            this.mList = list;
        }

        @Override
        public boolean hasNext() {
            return this.mPos < this.mList.size();
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("no more elements to iterate");
            }
            return this.mList.get(this.mPos++);
        }
    }
}

