/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.jems.iterable.decorators;

import java.util.Iterator;
import java.util.Locale;

public final class Chunked<T>
implements Iterable<Iterable<T>> {
    private final int mChunkSize;
    private final Iterable<T> mDelegate;

    public Chunked(int chunkSize, Iterable<T> delegate) {
        if (chunkSize <= 0) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Chunk size must be >0 but was %s", chunkSize));
        }
        this.mChunkSize = chunkSize;
        this.mDelegate = delegate;
    }

    @Override
    public Iterator<Iterable<T>> iterator() {
        return new org.dmfs.jems.iterator.decorators.Chunked<T>(this.mChunkSize, this.mDelegate.iterator());
    }
}

