/*
 * Copyright 2017 dmfs GmbH
 *
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.dmfs.jems.iterator.generators;

import org.dmfs.iterators.AbstractBaseIterator;

import java.util.Iterator;


/**
 * An {@link Iterator} which iterates the same constant value over and over again.
 *
 * @author Marten Gajda
 */
public final class ConstantGenerator<E> extends AbstractBaseIterator<E>
{
    private final E mValue;


    public ConstantGenerator(E value)
    {
        mValue = value;
    }


    @Override
    public boolean hasNext()
    {
        return true;
    }


    @Override
    public E next()
    {
        return mValue;
    }
}
