/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.httpessentials.httpurlconnection;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dmfs.httpessentials.headers.FilteredHeaders;
import org.dmfs.httpessentials.headers.Header;
import org.dmfs.httpessentials.headers.HeaderType;
import org.dmfs.httpessentials.headers.Headers;
import org.dmfs.httpessentials.headers.ListHeaderType;
import org.dmfs.httpessentials.headers.SingletonHeaderType;
import org.dmfs.httpessentials.headers.UpdatedHeaders;
import org.dmfs.httpessentials.httpurlconnection.utils.iterators.StringEqualsIgnoreCase;
import org.dmfs.iterators.Filter;
import org.dmfs.iterators.Function;
import org.dmfs.iterators.decorators.Filtered;
import org.dmfs.iterators.decorators.Flattened;
import org.dmfs.iterators.decorators.Mapped;

final class HttpUrlConnectionHeaders
implements Headers {
    private final Map<String, List<String>> mHeaders;

    public HttpUrlConnectionHeaders(Map<String, List<String>> headers) {
        this.mHeaders = headers;
    }

    public boolean contains(HeaderType<?> headerType) {
        return new Filtered(this.mHeaders.keySet().iterator(), (Filter)new StringEqualsIgnoreCase(headerType.name())).hasNext();
    }

    public Iterator<Header<?>> iterator() {
        throw new UnsupportedOperationException("Iterating headers is not supported by HttpUrlConnectionHeaders");
    }

    public <T> Header<T> header(SingletonHeaderType<T> headerType) {
        return headerType.entityFromString(this.mHeaders.get(new Filtered(this.mHeaders.keySet().iterator(), (Filter)new StringEqualsIgnoreCase(headerType.name())).next()).get(0));
    }

    public <T> Header<List<T>> header(final ListHeaderType<T> headerType) {
        Header result = headerType.entity(Collections.emptyList());
        Mapped headerIterator = new Mapped((Iterator)new Flattened((Iterator)new Mapped((Iterator)new Filtered(this.mHeaders.keySet().iterator(), (Filter)new StringEqualsIgnoreCase(headerType.name())), (Function)new Function<String, Iterable<String>>(){

            public Iterable<String> apply(String element) {
                return (Iterable)HttpUrlConnectionHeaders.this.mHeaders.get(element);
            }
        })), new Function<String, Header<List<T>>>(){

            public Header<List<T>> apply(String element) {
                return headerType.entityFromString(element);
            }
        });
        while (headerIterator.hasNext()) {
            result = headerType.merged(result, (Header)headerIterator.next());
        }
        return result;
    }

    public <T> Headers withHeader(Header<T> header) {
        return new UpdatedHeaders((Headers)this, header);
    }

    public <T> Headers withoutHeaderType(HeaderType<T> headerType) {
        return new FilteredHeaders((Headers)this, new HeaderType[]{headerType});
    }
}

