/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.httpessentials.httpurlconnection;

import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.util.List;
import java.util.Map;
import org.dmfs.httpessentials.client.HttpRequest;
import org.dmfs.httpessentials.client.HttpRequestExecutor;
import org.dmfs.httpessentials.client.HttpResponse;
import org.dmfs.httpessentials.exceptions.ProtocolError;
import org.dmfs.httpessentials.exceptions.ProtocolException;
import org.dmfs.httpessentials.exceptions.RedirectionException;
import org.dmfs.httpessentials.exceptions.UnexpectedStatusException;
import org.dmfs.httpessentials.headers.Header;
import org.dmfs.httpessentials.headers.HttpHeaders;
import org.dmfs.httpessentials.httpurlconnection.HttpUrlConnectionFactory;
import org.dmfs.httpessentials.httpurlconnection.HttpUrlConnectionResponse;
import org.dmfs.httpessentials.httpurlconnection.factories.DefaultHttpUrlConnectionFactory;
import org.dmfs.httpessentials.httpurlconnection.factories.decorators.Finite;

public final class PlainHttpUrlConnectionExecutor
implements HttpRequestExecutor {
    private final HttpUrlConnectionFactory mConnectionFactory;

    public PlainHttpUrlConnectionExecutor() {
        this(new Finite(new DefaultHttpUrlConnectionFactory()));
    }

    public PlainHttpUrlConnectionExecutor(HttpUrlConnectionFactory connectionFactory) {
        this.mConnectionFactory = connectionFactory;
    }

    public <T> T execute(URI uri, HttpRequest<T> request) throws IOException, ProtocolError, ProtocolException, RedirectionException, UnexpectedStatusException {
        HttpResponse r = this.sendRequest(uri, request);
        return (T)request.responseHandler(r).handleResponse(r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> HttpResponse sendRequest(URI uri, HttpRequest<T> request) throws IOException, ProtocolException {
        HttpURLConnection connection;
        try {
            connection = this.mConnectionFactory.httpUrlConnection(uri);
        }
        catch (IllegalArgumentException e) {
            throw new ProtocolException("The given URI is not applicable to HTTP requests.", (Throwable)e);
        }
        connection.setInstanceFollowRedirects(false);
        connection.setDoOutput(request.method().supportsRequestPayload());
        connection.setRequestMethod(request.method().verb());
        for (Header header : request.headers()) {
            connection.setRequestProperty(header.type().name(), header.toString());
        }
        if (request.requestEntity().contentType().isPresent()) {
            connection.setRequestProperty(HttpHeaders.CONTENT_TYPE.name(), HttpHeaders.CONTENT_TYPE.valueString(request.requestEntity().contentType().value()));
        }
        connection.connect();
        if (request.method().supportsRequestPayload()) {
            try (OutputStream out = connection.getOutputStream();){
                request.requestEntity().writeContent(out);
            }
        }
        connection.getResponseCode();
        Map<String, List<String>> headers = connection.getHeaderFields();
        if (headers == null) {
            throw new IOException("Can't read headers");
        }
        return new HttpUrlConnectionResponse(uri, connection, headers);
    }
}

