/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.httpessentials.executors.common.decoration;

import org.dmfs.httpessentials.decoration.Decoration;
import org.dmfs.httpessentials.executors.common.types.BottomBasicUserAgent;
import org.dmfs.httpessentials.headers.HeaderType;
import org.dmfs.httpessentials.headers.Headers;
import org.dmfs.httpessentials.headers.HttpHeaders;
import org.dmfs.httpessentials.types.Product;
import org.dmfs.httpessentials.types.SingletonUserAgent;
import org.dmfs.httpessentials.types.UserAgent;

public final class BottomUserAgentHeaderDecoration
implements Decoration<Headers> {
    private final Product mProduct;

    public BottomUserAgentHeaderDecoration(Product product) {
        this.mProduct = product;
    }

    public Headers decorated(Headers originalHeaders) {
        Object newUserAgent;
        if (originalHeaders.contains((HeaderType)HttpHeaders.USER_AGENT)) {
            UserAgent originalUserAgent = (UserAgent)originalHeaders.header(HttpHeaders.USER_AGENT).value();
            newUserAgent = new BottomBasicUserAgent(originalUserAgent, this.mProduct);
        } else {
            newUserAgent = new SingletonUserAgent(this.mProduct);
        }
        return originalHeaders.withHeader(HttpHeaders.USER_AGENT.entity(newUserAgent));
    }
}

