/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.httpessentials.headers;

import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.dmfs.httpessentials.headers.Header;
import org.dmfs.httpessentials.headers.HeaderType;
import org.dmfs.httpessentials.headers.Headers;
import org.dmfs.httpessentials.headers.ListHeaderType;
import org.dmfs.httpessentials.headers.SingletonHeaderType;
import org.dmfs.httpessentials.headers.UpdatedHeaders;
import org.dmfs.iterators.Filter;
import org.dmfs.iterators.decorators.Filtered;

public final class FilteredHeaders
implements Headers {
    private final Headers mOriginalHeaders;
    private final HeaderType<?>[] mFilteredHeaderTypes;

    public FilteredHeaders(Headers originalHeaders, HeaderType<?> ... filteredHeaderTypes) {
        this.mOriginalHeaders = originalHeaders;
        this.mFilteredHeaderTypes = filteredHeaderTypes;
    }

    public Iterator<Header<?>> iterator() {
        return new Filtered(this.mOriginalHeaders.iterator(), new Filter<Header<?>>(){

            public boolean iterate(Header<?> element) {
                return !FilteredHeaders.this.isFiltered(element.type());
            }
        });
    }

    public boolean contains(HeaderType<?> headerType) {
        return !this.isFiltered(headerType) && this.mOriginalHeaders.contains(headerType);
    }

    public <T> Header<T> header(SingletonHeaderType<T> headerType) {
        if (this.isFiltered((HeaderType<?>)headerType)) {
            throw new NoSuchElementException(String.format("No headers of type %s found", headerType.name()));
        }
        return this.mOriginalHeaders.header(headerType);
    }

    public <T> Header<List<T>> header(ListHeaderType<T> headerType) {
        if (this.isFiltered((HeaderType<?>)headerType)) {
            throw new NoSuchElementException(String.format("No headers of type %s found", headerType.name()));
        }
        return this.mOriginalHeaders.header(headerType);
    }

    public <T> Headers withHeader(Header<T> header) {
        if (this.mFilteredHeaderTypes.length == 1 && this.mFilteredHeaderTypes[0].equals((Object)header.type())) {
            return new UpdatedHeaders(this.mOriginalHeaders, header);
        }
        return new UpdatedHeaders(this, header);
    }

    public <T> Headers withoutHeaderType(HeaderType<T> headerType) {
        if (this.isFiltered(headerType)) {
            return this;
        }
        if (!this.mOriginalHeaders.contains(headerType)) {
            return this;
        }
        return new FilteredHeaders(this.mOriginalHeaders.withoutHeaderType(headerType), this.mFilteredHeaderTypes);
    }

    private boolean isFiltered(HeaderType<?> headerType) {
        for (HeaderType<?> type : this.mFilteredHeaderTypes) {
            if (!type.equals(headerType)) continue;
            return true;
        }
        return false;
    }
}

