/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.httpessentials.headers;

import java.util.Iterator;
import java.util.List;
import org.dmfs.httpessentials.headers.Header;
import org.dmfs.httpessentials.headers.HeaderType;
import org.dmfs.httpessentials.headers.Headers;
import org.dmfs.httpessentials.headers.ListHeaderType;
import org.dmfs.httpessentials.headers.SingletonHeaderType;
import org.dmfs.iterators.AbstractFilteredIterator;
import org.dmfs.iterators.FilteredIterator;
import org.dmfs.iterators.SerialIterator;
import org.dmfs.iterators.SingletonIterator;

public final class UpdatedHeaders
implements Headers {
    private final Headers mHeaders;
    private final Header<?> mNewHeader;

    public UpdatedHeaders(Headers headers, Header<?> updatedHeader) {
        this.mHeaders = headers;
        this.mNewHeader = updatedHeader;
    }

    public Iterator<Header<?>> iterator() {
        return new SerialIterator(new Iterator[]{new FilteredIterator(this.mHeaders.iterator(), new AbstractFilteredIterator.IteratorFilter<Header<?>>(){

            public boolean iterate(Header<?> element) {
                return !element.type().equals(UpdatedHeaders.this.mNewHeader.type());
            }
        }), new SingletonIterator(this.mNewHeader)});
    }

    public boolean contains(HeaderType<?> headerType) {
        return this.mNewHeader.type().equals(headerType) || this.mHeaders.contains(headerType);
    }

    public <T> Header<T> header(SingletonHeaderType<T> headerType) {
        return this.mNewHeader.type().equals(headerType) ? this.mNewHeader : this.mHeaders.header(headerType);
    }

    public <T> Header<List<T>> header(ListHeaderType<T> headerType) {
        return this.mNewHeader.type().equals(headerType) ? this.mNewHeader : this.mHeaders.header(headerType);
    }

    public <T> Headers withHeader(Header<T> header) {
        if (this.mNewHeader.type().equals(header.type())) {
            return new UpdatedHeaders(this.mHeaders, header);
        }
        return new UpdatedHeaders(this, header);
    }

    public <T> Headers withoutHeaderType(HeaderType<T> headerType) {
        if (this.mNewHeader.type().equals(headerType)) {
            return this.mHeaders.withoutHeaderType(headerType);
        }
        if (this.mHeaders.contains(headerType)) {
            return new UpdatedHeaders(this.mHeaders.withoutHeaderType(headerType), this.mNewHeader);
        }
        return this;
    }
}

