/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.httpessentials.decoration;

import org.dmfs.httpessentials.HttpMethod;
import org.dmfs.httpessentials.client.HttpRequest;
import org.dmfs.httpessentials.client.HttpRequestEntity;
import org.dmfs.httpessentials.client.HttpResponse;
import org.dmfs.httpessentials.client.HttpResponseHandler;
import org.dmfs.httpessentials.decoration.Decoration;
import org.dmfs.httpessentials.headers.Headers;

public final class ResponseDecorated<T>
implements HttpRequest<T> {
    private final HttpRequest<T> mOriginalRequest;
    private final Decoration<HttpResponse> mResponseDecoration;

    public ResponseDecorated(HttpRequest<T> originalRequest, Decoration<HttpResponse> responseDecoration) {
        this.mOriginalRequest = originalRequest;
        this.mResponseDecoration = responseDecoration;
    }

    public HttpMethod method() {
        return this.mOriginalRequest.method();
    }

    public Headers headers() {
        return this.mOriginalRequest.headers();
    }

    public HttpRequestEntity requestEntity() {
        return this.mOriginalRequest.requestEntity();
    }

    public HttpResponseHandler<T> responseHandler(HttpResponse response) {
        return response1 -> {
            HttpResponse decoratedResponse = this.mResponseDecoration.decorated(response1);
            return this.mOriginalRequest.responseHandler(decoratedResponse).handleResponse(decoratedResponse);
        };
    }
}

