/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.util;

import java.lang.reflect.Array;
import java.util.Map;
import org.dizitart.no2.util.Iterables;
import org.dizitart.no2.util.NumberUtils;

public final class EqualsUtils {
    public static boolean deepEquals(Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        if (o1 == o2) {
            return true;
        }
        if (o1 instanceof Number && o2 instanceof Number) {
            if (o1.getClass() != o2.getClass()) {
                return false;
            }
            return NumberUtils.compare((Number)o1, (Number)o2) == 0;
        }
        if (o1 instanceof Iterable && o2 instanceof Iterable) {
            Object[] arr1 = Iterables.toArray((Iterable)o1);
            Object[] arr2 = Iterables.toArray((Iterable)o2);
            return EqualsUtils.deepEquals(arr1, arr2);
        }
        if (o1.getClass().isArray() && o2.getClass().isArray()) {
            int length = Array.getLength(o1);
            if (length != Array.getLength(o2)) {
                return false;
            }
            for (int i = 0; i < length; ++i) {
                Object item2;
                Object item1 = Array.get(o1, i);
                if (EqualsUtils.deepEquals(item1, item2 = Array.get(o2, i))) continue;
                return false;
            }
            return true;
        }
        if (o1 instanceof Map && o2 instanceof Map) {
            Map map1 = (Map)o1;
            Map map2 = (Map)o2;
            return EqualsUtils.deepEquals(Iterables.toArray(map1.entrySet()), Iterables.toArray(map2.entrySet()));
        }
        return o1.equals(o2);
    }

    private EqualsUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

