/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.tool;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.charset.StandardCharsets;
import java.sql.Timestamp;
import java.util.Map;
import java.util.TreeMap;
import org.dizitart.no2.exceptions.ErrorMessage;
import org.dizitart.no2.util.ValidationUtils;
import org.h2.mvstore.Chunk;
import org.h2.mvstore.DataUtils;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.MVStore;
import org.h2.store.fs.FilePath;
import org.h2.store.fs.FileUtils;

public class Recovery {
    private static final int BLOCK_SIZE = 4096;
    private static final int MAX_HEADER_LENGTH = 1024;

    public static boolean recover(String fileName) {
        return Recovery.recover(fileName, new PrintWriter(System.out));
    }

    public static boolean recover(String fileName, PrintWriter writer) {
        ValidationUtils.notNull(fileName, ErrorMessage.errorMessage("fileName can not be null", 1064));
        ValidationUtils.notEmpty(fileName, ErrorMessage.errorMessage("fileName can not be empty", 1065));
        ValidationUtils.notNull(writer, ErrorMessage.errorMessage("writer can not be null", 1066));
        return Recovery.repair(fileName, writer);
    }

    private static boolean repair(String fileName, PrintWriter pw) {
        OutputStream ignore = new OutputStream(){

            @Override
            public void write(int b) {
            }
        };
        boolean repaired = false;
        for (long version = Long.MAX_VALUE; version >= 0L; --version) {
            pw.println(version == Long.MAX_VALUE ? "Trying latest version" : "Trying version " + version);
            pw.flush();
            version = Recovery.rollback(fileName, version, new PrintWriter(ignore));
            try {
                String error = Recovery.info(fileName + ".temp", new PrintWriter(ignore));
                if (error == null) {
                    FilePath.get((String)fileName).moveTo(FilePath.get((String)(fileName + ".back")), true);
                    FilePath.get((String)(fileName + ".temp")).moveTo(FilePath.get((String)fileName), true);
                    pw.println("Success");
                    repaired = true;
                    break;
                }
                pw.println("    ... failed: " + error);
                continue;
            }
            catch (Exception e) {
                pw.println("Fail: " + e.getMessage());
                pw.flush();
            }
        }
        pw.flush();
        return repaired;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long rollback(String fileName, long targetVersion, Writer writer) {
        long newestVersion = -1L;
        PrintWriter pw = new PrintWriter(writer, true);
        if (!FilePath.get((String)fileName).exists()) {
            pw.println("File not found: " + fileName);
            return newestVersion;
        }
        FileChannel file = null;
        AbstractInterruptibleChannel target = null;
        int blockSize = 4096;
        try {
            file = FilePath.get((String)fileName).open("r");
            FilePath.get((String)(fileName + ".temp")).delete();
            target = FilePath.get((String)(fileName + ".temp")).open("rw");
            long fileSize = file.size();
            ByteBuffer block = ByteBuffer.allocate(4096);
            Chunk newestChunk = null;
            long pos = 0L;
            while (pos < fileSize) {
                Chunk c;
                block.rewind();
                DataUtils.readFully((FileChannel)file, (long)pos, (ByteBuffer)block);
                block.rewind();
                byte headerType = block.get();
                if (headerType == 72) {
                    block.rewind();
                    ((FileChannel)target).write(block, pos);
                    pos += (long)blockSize;
                    continue;
                }
                if (headerType != 99) {
                    pos += (long)blockSize;
                    continue;
                }
                try {
                    c = Recovery.readChunkHeader(block, pos);
                }
                catch (IllegalStateException e) {
                    pos += (long)blockSize;
                    continue;
                }
                if (c.len <= 0) {
                    pos += (long)blockSize;
                    continue;
                }
                int length = c.len * 4096;
                ByteBuffer chunk = ByteBuffer.allocate(length);
                DataUtils.readFully((FileChannel)file, (long)pos, (ByteBuffer)chunk);
                if (c.version > targetVersion) {
                    pos += (long)length;
                    continue;
                }
                chunk.rewind();
                ((FileChannel)target).write(chunk, pos);
                if (newestChunk == null || c.version > newestChunk.version) {
                    newestChunk = c;
                    newestVersion = c.version;
                }
                pos += (long)length;
            }
            if (newestChunk != null) {
                int length = newestChunk.len * 4096;
                ByteBuffer chunk = ByteBuffer.allocate(length);
                DataUtils.readFully((FileChannel)file, (long)(newestChunk.block * 4096L), (ByteBuffer)chunk);
                chunk.rewind();
                ((FileChannel)target).write(chunk, fileSize);
            }
        }
        catch (IOException e) {
            pw.println("ERROR: " + e);
            e.printStackTrace(pw);
        }
        finally {
            if (file != null) {
                try {
                    file.close();
                }
                catch (IOException iOException) {}
            }
            if (target != null) {
                try {
                    target.close();
                }
                catch (IOException iOException) {}
            }
        }
        pw.flush();
        return newestVersion;
    }

    private static Chunk readChunkHeader(ByteBuffer buff, long start) {
        int pos = buff.position();
        byte[] data = new byte[Math.min(buff.remaining(), 1024)];
        buff.get(data);
        try {
            for (int i = 0; i < data.length; ++i) {
                if (data[i] != 10) continue;
                buff.position(pos + i + 1);
                String s = new String(data, 0, i, StandardCharsets.ISO_8859_1).trim();
                return Chunk.fromString((String)s);
            }
        }
        catch (Exception e) {
            throw DataUtils.newIllegalStateException((int)6, (String)"File corrupt reading chunk at position {0}", (Object[])new Object[]{start, e});
        }
        throw DataUtils.newIllegalStateException((int)6, (String)"File corrupt reading chunk at position {0}", (Object[])new Object[]{start});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String info(String fileName, Writer writer) {
        PrintWriter pw = new PrintWriter(writer, true);
        if (!FilePath.get((String)fileName).exists()) {
            pw.println("File not found: " + fileName);
            return "File not found: " + fileName;
        }
        long fileLength = FileUtils.size((String)fileName);
        try (MVStore store = new MVStore.Builder().fileName(fileName).readOnly().open();){
            MVMap meta = store.getMetaMap();
            Map header = store.getStoreHeader();
            long fileCreated = DataUtils.readHexLong((Map)header, (String)"created", (long)0L);
            TreeMap<Integer, Chunk> chunks = new TreeMap<Integer, Chunk>();
            long chunkLength = 0L;
            long maxLength = 0L;
            long maxLengthLive = 0L;
            long maxLengthNotEmpty = 0L;
            for (Map.Entry entry : meta.entrySet()) {
                String k = (String)entry.getKey();
                if (!k.startsWith("chunk.")) continue;
                Chunk c = Chunk.fromString((String)((String)entry.getValue()));
                chunks.put(c.id, c);
                chunkLength += (long)(c.len * 4096);
                maxLength += c.maxLen;
                maxLengthLive += c.maxLenLive;
                if (c.maxLenLive <= 0L) continue;
                maxLengthNotEmpty += c.maxLen;
            }
            pw.printf("Created: %s\n", Recovery.formatTimestamp(fileCreated, fileCreated));
            pw.printf("Last modified: %s\n", Recovery.formatTimestamp(FileUtils.lastModified((String)fileName), fileCreated));
            pw.printf("File length: %d\n", fileLength);
            pw.printf("The last chunk is not listed\n", new Object[0]);
            pw.printf("Chunk length: %d\n", chunkLength);
            pw.printf("Chunk count: %d\n", chunks.size());
            pw.printf("Used space: %d%%\n", Recovery.getPercent(chunkLength, fileLength));
            pw.printf("Chunk fill rate: %d%%\n", maxLength == 0L ? 100 : Recovery.getPercent(maxLengthLive, maxLength));
            pw.printf("Chunk fill rate excluding empty chunks: %d%%\n", maxLengthNotEmpty == 0L ? 100 : Recovery.getPercent(maxLengthLive, maxLengthNotEmpty));
            for (Map.Entry entry : chunks.entrySet()) {
                Chunk c = (Chunk)entry.getValue();
                long created = fileCreated + c.time;
                pw.printf("  Chunk %d: %s, %d%% used, %d blocks", c.id, Recovery.formatTimestamp(created, fileCreated), Recovery.getPercent(c.maxLenLive, c.maxLen), c.len);
                if (c.maxLenLive == 0L) {
                    pw.printf(", unused: %s", Recovery.formatTimestamp(fileCreated + c.unused, fileCreated));
                }
                pw.printf("\n", new Object[0]);
            }
            pw.printf("\n", new Object[0]);
        }
        pw.flush();
        return null;
    }

    private static String formatTimestamp(long t, long start) {
        String x = new Timestamp(t).toString();
        String s = x.substring(0, 19);
        s = s + " (+" + (t - start) / 1000L + " s)";
        return s;
    }

    private static int getPercent(long value, long max) {
        if (value == 0L) {
            return 0;
        }
        if (value == max) {
            return 100;
        }
        return (int)(1L + 98L * value / Math.max(1L, max));
    }
}

