/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.sync;

import java.util.List;
import org.dizitart.no2.Cursor;
import org.dizitart.no2.Document;
import org.dizitart.no2.FindOptions;
import org.dizitart.no2.NitriteCollection;
import org.dizitart.no2.event.EventBus;
import org.dizitart.no2.filters.Filters;
import org.dizitart.no2.meta.Attributes;
import org.dizitart.no2.sync.EventType;
import org.dizitart.no2.sync.LocalCollection;
import org.dizitart.no2.sync.SyncConfig;
import org.dizitart.no2.sync.SyncEventData;
import org.dizitart.no2.sync.SyncEventListener;
import org.dizitart.no2.sync.SyncTemplate;
import org.dizitart.no2.sync.data.ChangeFeed;
import org.dizitart.no2.sync.data.FeedOptions;
import org.dizitart.no2.util.Iterables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SyncService {
    private static final Logger log = LoggerFactory.getLogger(SyncService.class);
    private SyncConfig syncConfig;
    private NitriteCollection changeLogRepository;
    private EventBus<SyncEventData, SyncEventListener> syncEventBus;
    private LocalCollection localCollection;
    private String originator;
    private SyncTemplate syncTemplate;

    SyncService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void pullChanges() {
        if (this.syncTemplate.isOnline()) {
            try {
                if (this.syncTemplate.trySyncLock(this.syncConfig.getSyncDelay(), this.originator)) {
                    this.notifyEvent(EventType.IN_PROGRESS);
                    Attributes attributes = this.localCollection.getAttributes();
                    attributes = attributes == null ? new Attributes(this.localCollection.getName()) : attributes;
                    long from = attributes.getLastSynced();
                    FeedOptions feedOptions = new FeedOptions();
                    feedOptions.setFromSequence(from);
                    ChangeFeed remoteChangeFeed = this.syncTemplate.changedSince(feedOptions);
                    this.localCollection.change(remoteChangeFeed);
                    attributes.setLastSynced(remoteChangeFeed.getSequenceNumber());
                    this.localCollection.setAttributes(attributes);
                    this.notifyEvent(EventType.COMPLETED);
                }
            }
            catch (Exception error) {
                this.notifyErrorEvent(error, EventType.REPLICATION_ERROR);
            }
            finally {
                this.syncTemplate.releaseLock(this.originator);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void pushChanges() {
        if (this.syncTemplate.isOnline()) {
            try {
                if (this.syncTemplate.trySyncLock(this.syncConfig.getSyncDelay(), this.originator)) {
                    this.notifyEvent(EventType.IN_PROGRESS);
                    Attributes attributes = this.localCollection.getAttributes();
                    attributes = attributes == null ? new Attributes(this.localCollection.getName()) : attributes;
                    long lastSequence = attributes.getLastSynced();
                    long newSequence = System.currentTimeMillis();
                    ChangeFeed changeFeed = this.localCollection.changedSince(lastSequence, newSequence);
                    changeFeed.setOriginator(this.originator);
                    changeFeed.setSequenceNumber(newSequence);
                    if (this.syncTemplate.change(changeFeed)) {
                        this.clearRemoveLogSince(newSequence);
                    }
                    attributes.setLastSynced(newSequence);
                    this.localCollection.setAttributes(attributes);
                    this.notifyEvent(EventType.COMPLETED);
                }
            }
            catch (Exception error) {
                this.notifyErrorEvent(error, EventType.REPLICATION_ERROR);
            }
            finally {
                this.syncTemplate.releaseLock(this.originator);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void mergeChanges() {
        if (this.syncTemplate.isOnline()) {
            try {
                if (this.syncTemplate.trySyncLock(this.syncConfig.getSyncDelay(), this.originator)) {
                    this.notifyEvent(EventType.IN_PROGRESS);
                    Attributes attributes = this.localCollection.getAttributes() == null ? new Attributes(this.localCollection.getName()) : this.localCollection.getAttributes();
                    long lastSequence = attributes.getLastSynced();
                    FeedOptions feedOptions = new FeedOptions();
                    feedOptions.setFromSequence(lastSequence);
                    ChangeFeed remoteChanges = this.syncTemplate.changedSince(feedOptions);
                    ChangeFeed localChanges = this.localCollection.changedSince(lastSequence, remoteChanges.getSequenceNumber());
                    localChanges.setOriginator(this.originator);
                    if (this.mergeChanges(remoteChanges, localChanges)) {
                        this.clearRemoveLogSince(remoteChanges.getSequenceNumber());
                    }
                    attributes.setLastSynced(remoteChanges.getSequenceNumber());
                    this.localCollection.setAttributes(attributes);
                    this.notifyEvent(EventType.COMPLETED);
                }
            }
            catch (Exception error) {
                this.notifyErrorEvent(error, EventType.REPLICATION_ERROR);
            }
            finally {
                this.syncTemplate.releaseLock(this.originator);
            }
        }
    }

    void resetLocalWithRemote(int offset, int size) {
        if (this.syncTemplate.isOnline()) {
            try {
                this.notifyEvent(EventType.IN_PROGRESS);
                this.localCollection.clear();
                List<Document> documents = this.syncTemplate.fetch(offset, size);
                for (Document document : documents) {
                    document.put("_source", (Object)"Replicator.NO\u2082");
                }
                this.localCollection.insert(documents.toArray(new Document[0]));
                this.notifyEvent(EventType.COMPLETED);
            }
            catch (Exception error) {
                this.notifyErrorEvent(error, EventType.REPLICATION_ERROR);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resetRemoteWithLocal(int offset, int size) {
        if (this.syncTemplate.isOnline()) {
            try {
                if (this.syncTemplate.trySyncLock(this.syncConfig.getSyncDelay(), this.originator)) {
                    this.notifyEvent(EventType.IN_PROGRESS);
                    this.syncTemplate.clear();
                    NitriteCollection nitriteCollection = this.localCollection.getCollection();
                    Cursor documents = nitriteCollection.find(FindOptions.limit(offset, size));
                    ChangeFeed changeFeed = new ChangeFeed();
                    changeFeed.setModifiedDocuments(Iterables.toList(documents));
                    changeFeed.setOriginator(this.originator);
                    this.syncTemplate.change(changeFeed);
                    this.notifyEvent(EventType.COMPLETED);
                }
            }
            catch (Exception error) {
                this.notifyErrorEvent(error, EventType.REPLICATION_ERROR);
            }
            finally {
                this.syncTemplate.releaseLock(this.originator);
            }
        }
    }

    void setSyncConfig(SyncConfig syncConfig) {
        this.syncConfig = syncConfig;
        this.syncTemplate = syncConfig.getSyncTemplate();
    }

    void setLocalCollection(LocalCollection localCollection) {
        this.localCollection = localCollection;
        this.localCollection.setChangeLogRepository(this.changeLogRepository);
        Attributes attributes = localCollection.getAttributes() == null ? new Attributes(localCollection.getName()) : localCollection.getAttributes();
        localCollection.setAttributes(attributes);
        this.originator = attributes.getUuid();
    }

    private void clearRemoveLogSince(long upto) {
        this.changeLogRepository.remove(Filters.and(Filters.eq("collection", this.localCollection.getName()), Filters.lte("deleteTime", upto)));
    }

    private boolean mergeChanges(ChangeFeed remoteChanges, ChangeFeed localChanges) {
        boolean result = this.syncTemplate.change(localChanges);
        this.localCollection.change(remoteChanges);
        return result;
    }

    void notifyEvent(EventType eventType) {
        SyncEventData eventData = new SyncEventData();
        eventData.setEventType(eventType);
        eventData.setCollectionName(this.localCollection.getName());
        this.syncEventBus.post(eventData);
    }

    private void notifyErrorEvent(Throwable error, EventType eventType) {
        log.error("Replication error", error);
        SyncEventData eventData = new SyncEventData();
        eventData.setEventType(eventType);
        eventData.setCollectionName(this.localCollection.getName());
        eventData.setError(error);
        this.syncEventBus.post(eventData);
    }

    public SyncConfig getSyncConfig() {
        return this.syncConfig;
    }

    public NitriteCollection getChangeLogRepository() {
        return this.changeLogRepository;
    }

    public void setChangeLogRepository(NitriteCollection changeLogRepository) {
        this.changeLogRepository = changeLogRepository;
    }

    public EventBus<SyncEventData, SyncEventListener> getSyncEventBus() {
        return this.syncEventBus;
    }

    public void setSyncEventBus(EventBus<SyncEventData, SyncEventListener> syncEventBus) {
        this.syncEventBus = syncEventBus;
    }

    public LocalCollection getLocalCollection() {
        return this.localCollection;
    }
}

