/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.sync;

import com.fasterxml.jackson.databind.ObjectMapper;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.dizitart.no2.exceptions.ErrorMessage;
import org.dizitart.no2.exceptions.SyncException;
import org.dizitart.no2.sync.DataGateClient;
import org.dizitart.no2.sync.data.UserAccount;
import org.dizitart.no2.util.ResponseUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataGateUserTemplate {
    private static final Logger log = LoggerFactory.getLogger(DataGateUserTemplate.class);
    private static final MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
    private static final String userUrl = "/datagate/api/v1/user";
    private DataGateClient dataGateClient;
    private ObjectMapper objectMapper;

    public DataGateUserTemplate(DataGateClient dataGateClient) {
        this.dataGateClient = dataGateClient;
        this.objectMapper = new ObjectMapper();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public UserAccount getUserAccount(String username) {
        String url = this.dataGateClient.getServerBaseUrl() + userUrl + "/" + username;
        OkHttpClient httpClient = this.dataGateClient.getHttpClient();
        Request request = new Request.Builder().url(url).get().build();
        try (Response response = httpClient.newCall(request).execute();){
            if (!response.isSuccessful()) {
                throw new SyncException(ErrorMessage.errorMessage(ResponseUtils.errorResponse(response), 11015));
            }
            UserAccount userAccount = (UserAccount)this.objectMapper.readValue(response.body().bytes(), UserAccount.class);
            return userAccount;
        }
        catch (Exception e) {
            log.error("Remote error while getting user details", (Throwable)e);
            throw new SyncException(ErrorMessage.errorMessage("remote error while getting details for user " + username, 11001), (Throwable)e);
        }
    }

    public void createRemoteUser(UserAccount userAccount) {
        String url = this.dataGateClient.getServerBaseUrl() + userUrl + "/create";
        OkHttpClient httpClient = this.dataGateClient.getHttpClient();
        try (Response response = null;){
            String jsonUser = this.objectMapper.writeValueAsString((Object)userAccount);
            Request request = new Request.Builder().url(url).post(RequestBody.create((MediaType)JSON, (String)jsonUser)).build();
            response = httpClient.newCall(request).execute();
            if (!response.isSuccessful()) {
                throw new SyncException(ErrorMessage.errorMessage(ResponseUtils.errorResponse(response), 11003));
            }
        }
    }

    public void updateRemoteUser(UserAccount userAccount) {
        String url = this.dataGateClient.getServerBaseUrl() + userUrl + "/update";
        OkHttpClient httpClient = this.dataGateClient.getHttpClient();
        try (Response response = null;){
            String jsonUser = this.objectMapper.writeValueAsString((Object)userAccount);
            Request request = new Request.Builder().url(url).put(RequestBody.create((MediaType)JSON, (String)jsonUser)).build();
            response = httpClient.newCall(request).execute();
            if (!response.isSuccessful()) {
                throw new SyncException(ErrorMessage.errorMessage(ResponseUtils.errorResponse(response), 11022));
            }
        }
    }

    public void deleteRemoteUser(String username) {
        String url = this.dataGateClient.getServerBaseUrl() + userUrl + "/delete/" + username;
        OkHttpClient httpClient = this.dataGateClient.getHttpClient();
        Request request = new Request.Builder().url(url).delete().build();
        try (Response response = httpClient.newCall(request).execute();){
            if (!response.isSuccessful()) {
                throw new SyncException(ErrorMessage.errorMessage(ResponseUtils.errorResponse(response), 11004));
            }
        }
        catch (SyncException se) {
            throw se;
        }
        catch (Exception e) {
            log.error("Remote error while deleting user", (Throwable)e);
            throw new SyncException(ErrorMessage.errorMessage("remote error while deleting user " + username, 11005), (Throwable)e);
        }
    }
}

