/*
 * Decompiled with CFR 0.152.
 */
package com.discoveryone.navigation;

import android.content.Context;
import android.content.Intent;
import androidx.core.os.BundleKt;
import androidx.fragment.app.FragmentActivity;
import com.discoveryone.extensions.AbstractDestinationExtensionsKt;
import com.discoveryone.navigation.NavigationContext;
import com.discoveryone.navigation.result.ResultRegistry;
import com.discoveryone.routes.AbstractRoute;
import com.discoveryone.routes.GeneratedActivityRoute;
import java.util.Arrays;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\u0007J%\u0010\b\u001a\u00020\u0004\"\u0004\b\u0000\u0010\t2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u0002H\tH\u0000\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0016\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fJ\u001e\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f\u00a8\u0006\u0013"}, d2={"Lcom/discoveryone/navigation/ActivityNavigation;", "", "()V", "close", "", "currentActivity", "Landroidx/fragment/app/FragmentActivity;", "close$runtime_release", "closeWithResult", "T", "result", "closeWithResult$runtime_release", "(Landroidx/fragment/app/FragmentActivity;Ljava/lang/Object;)V", "navigate", "route", "Lcom/discoveryone/routes/GeneratedActivityRoute;", "navigateForResult", "navigationContext", "Lcom/discoveryone/navigation/NavigationContext;", "runtime_release"})
public final class ActivityNavigation {
    public static final ActivityNavigation INSTANCE;

    public final void navigate(@NotNull FragmentActivity currentActivity, @NotNull GeneratedActivityRoute route) {
        Intrinsics.checkParameterIsNotNull((Object)currentActivity, (String)"currentActivity");
        Intrinsics.checkParameterIsNotNull((Object)route, (String)"route");
        Collection $this$toTypedArray$iv = AbstractDestinationExtensionsKt.extractPropertiesForBundle((AbstractRoute)route);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Pair[] pairArray = thisCollection$iv.toArray(new Pair[0]);
        if (pairArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        Pair[] properties = pairArray;
        Intent intent = new Intent((Context)currentActivity, JvmClassMappingKt.getJavaClass((KClass)route.getClazz())).putExtras(BundleKt.bundleOf((Pair[])Arrays.copyOf(properties, properties.length)));
        Intrinsics.checkExpressionValueIsNotNull((Object)intent, (String)"Intent(currentActivity, \u2026as(bundleOf(*properties))");
        Intent intent2 = intent;
        currentActivity.startActivity(intent2);
    }

    public final void navigateForResult(@NotNull NavigationContext navigationContext, @NotNull FragmentActivity currentActivity, @NotNull GeneratedActivityRoute route) {
        Intrinsics.checkParameterIsNotNull((Object)navigationContext, (String)"navigationContext");
        Intrinsics.checkParameterIsNotNull((Object)currentActivity, (String)"currentActivity");
        Intrinsics.checkParameterIsNotNull((Object)route, (String)"route");
        Collection $this$toTypedArray$iv = AbstractDestinationExtensionsKt.extractPropertiesForBundle((AbstractRoute)route);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Pair[] pairArray = thisCollection$iv.toArray(new Pair[0]);
        if (pairArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        Pair[] properties = pairArray;
        Intent intent = new Intent((Context)currentActivity, JvmClassMappingKt.getJavaClass((KClass)route.getClazz())).putExtras(BundleKt.bundleOf((Pair[])Arrays.copyOf(properties, properties.length)));
        Intrinsics.checkExpressionValueIsNotNull((Object)intent, (String)"Intent(currentActivity, \u2026as(bundleOf(*properties))");
        Intent intent2 = intent;
        ResultRegistry.INSTANCE.executeActivityResultLauncher(Reflection.getOrCreateKotlinClass(route.getClass()), navigationContext, intent2);
    }

    public final void close$runtime_release(@NotNull FragmentActivity currentActivity) {
        Intrinsics.checkParameterIsNotNull((Object)currentActivity, (String)"currentActivity");
        currentActivity.finish();
    }

    public final <T> void closeWithResult$runtime_release(@NotNull FragmentActivity currentActivity, T result) {
        Intrinsics.checkParameterIsNotNull((Object)currentActivity, (String)"currentActivity");
        currentActivity.setResult(-1, new Intent().putExtras(BundleKt.bundleOf((Pair[])new Pair[]{TuplesKt.to((Object)"default_intent_extra_key", result)})));
        currentActivity.finish();
    }

    private ActivityNavigation() {
    }

    static {
        ActivityNavigation activityNavigation;
        INSTANCE = activityNavigation = new ActivityNavigation();
    }
}

