/*
 * Decompiled with CFR 0.152.
 */
package com.discoveryone.initialization;

import android.app.Activity;
import android.app.Application;
import android.os.Bundle;
import android.util.Log;
import androidx.annotation.VisibleForTesting;
import androidx.fragment.app.FragmentActivity;
import com.discoveryone.exceptions.NoActivityOnStack;
import com.discoveryone.navigation.result.ResultRegistry;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0006\u001a\u00020\u0007H\u0007J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rH\u0007J\u0006\u0010\u000e\u001a\u00020\u0005J\b\u0010\u000f\u001a\u00020\u0007H\u0002J\u000e\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0012R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/discoveryone/initialization/ActivityInterceptor;", "", "()V", "activities", "", "Landroidx/fragment/app/FragmentActivity;", "clear", "", "getActivityByHashCode", "hashCode", "", "getActivityByName", "name", "", "getLast", "logLastActivity", "register", "application", "Landroid/app/Application;", "runtime_release"})
public final class ActivityInterceptor {
    private static final Set<FragmentActivity> activities;
    public static final ActivityInterceptor INSTANCE;

    public final void register(@NotNull Application application) {
        Intrinsics.checkParameterIsNotNull((Object)application, (String)"application");
        application.registerActivityLifecycleCallbacks(new Application.ActivityLifecycleCallbacks(){

            public void onActivityCreated(@NotNull Activity activity, @Nullable Bundle savedInstanceState) {
                Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
                if (!(activity instanceof FragmentActivity)) {
                    return;
                }
                ActivityInterceptor.access$getActivities$p(ActivityInterceptor.INSTANCE).add(activity);
            }

            public void onActivityDestroyed(@NotNull Activity activity) {
                Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
                ResultRegistry.INSTANCE.unregisterActivityResultLauncher(activity);
            }

            public void onActivityStopped(@NotNull Activity activity) {
                Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
                Collection collection = ActivityInterceptor.access$getActivities$p(ActivityInterceptor.INSTANCE);
                boolean bl = false;
                Collection collection2 = collection;
                if (collection2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.MutableCollection<T>");
                }
                TypeIntrinsics.asMutableCollection((Object)collection2).remove(activity);
            }

            public void onActivityStarted(@NotNull Activity activity) {
                Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
                if (!(activity instanceof FragmentActivity)) {
                    return;
                }
                ActivityInterceptor.access$getActivities$p(ActivityInterceptor.INSTANCE).add(activity);
                ActivityInterceptor.access$logLastActivity(ActivityInterceptor.INSTANCE);
            }

            public void onActivityPaused(@NotNull Activity activity) {
                Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
            }

            public void onActivityResumed(@NotNull Activity activity) {
                Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
            }

            public void onActivitySaveInstanceState(@NotNull Activity activity, @NotNull Bundle outState) {
                Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
                Intrinsics.checkParameterIsNotNull((Object)outState, (String)"outState");
            }
        });
    }

    private final void logLastActivity() {
        Log.i((String)"DiscoveryOne", (String)("current activity: " + this.getLast()));
    }

    @NotNull
    public final FragmentActivity getLast() {
        FragmentActivity fragmentActivity = (FragmentActivity)CollectionsKt.lastOrNull((Iterable)activities);
        if (fragmentActivity == null) {
            throw (Throwable)new NoActivityOnStack();
        }
        return fragmentActivity;
    }

    @NotNull
    public final FragmentActivity getActivityByHashCode(int hashCode) {
        Object element$iv2;
        block1: {
            Iterable $this$first$iv = activities;
            boolean $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                FragmentActivity it = (FragmentActivity)element$iv2;
                boolean bl = false;
                if (!(it.hashCode() == hashCode)) continue;
                break block1;
            }
            throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        return (FragmentActivity)element$iv2;
    }

    @VisibleForTesting
    @NotNull
    public final FragmentActivity getActivityByName(@NotNull String name) {
        Object element$iv2;
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            Iterable $this$first$iv = activities;
            boolean $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                FragmentActivity it = (FragmentActivity)element$iv2;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)Reflection.getOrCreateKotlinClass(it.getClass()).getSimpleName(), (Object)name)) continue;
                break block1;
            }
            throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        return (FragmentActivity)element$iv2;
    }

    @VisibleForTesting
    public final void clear() {
        activities.clear();
    }

    private ActivityInterceptor() {
    }

    static {
        ActivityInterceptor activityInterceptor;
        INSTANCE = activityInterceptor = new ActivityInterceptor();
        activities = new LinkedHashSet();
    }

    public static final /* synthetic */ Set access$getActivities$p(ActivityInterceptor $this) {
        ActivityInterceptor activityInterceptor = $this;
        return activities;
    }

    public static final /* synthetic */ void access$logLastActivity(ActivityInterceptor $this) {
        $this.logLastActivity();
    }
}

