/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.spring;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.Container;
import org.directwebremoting.extend.ContainerConfigurationException;
import org.directwebremoting.impl.DefaultContainer;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringContainer
extends DefaultContainer
implements Container,
BeanFactoryAware,
InitializingBean {
    protected BeanFactory beanFactory;
    private static final Log log = LogFactory.getLog(SpringContainer.class);

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    @Override
    public void addParameter(String askFor, Object valueParam) throws ContainerConfigurationException {
        try {
            Class clz = ClassUtils.forName((String)askFor);
            if (log.isDebugEnabled()) {
                log.debug((Object)("trying to resolve the following class from the Spring bean container: " + clz.getName()));
            }
            Map beansOfType = ((ListableBeanFactory)this.beanFactory).getBeansOfType(clz);
            if (log.isDebugEnabled()) {
                log.debug((Object)("beans: " + beansOfType + " - " + beansOfType.size()));
            }
            if (beansOfType.isEmpty()) {
                log.debug((Object)"adding parameter the normal way");
                super.addParameter(askFor, valueParam);
            } else {
                if (beansOfType.size() > 1) {
                    throw new ContainerConfigurationException("multiple beans of type '" + clz.getName() + "' were found in the spring configuration");
                }
                this.beans.put(askFor, beansOfType.values().iterator().next());
            }
        }
        catch (ClassNotFoundException ex) {
            super.addParameter(askFor, valueParam);
        }
    }

    @Override
    public Object getBean(String id) {
        Object reply;
        try {
            reply = this.beanFactory.getBean(id);
        }
        catch (BeansException ex) {
            reply = super.getBean(id);
        }
        return reply;
    }

    @Override
    public Collection<String> getBeanNames() {
        ArrayList<String> names = new ArrayList<String>();
        if (this.beanFactory instanceof ListableBeanFactory) {
            ListableBeanFactory listable = (ListableBeanFactory)this.beanFactory;
            names.addAll(Arrays.asList(listable.getBeanDefinitionNames()));
        } else {
            log.warn((Object)"List of beanNames does not include Spring beans since your BeanFactory is not a ListableBeanFactory.");
        }
        names.addAll(super.getBeanNames());
        return Collections.unmodifiableCollection(names);
    }

    public void afterPropertiesSet() throws Exception {
        this.callInitializingBeans();
    }
}

