/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.servlet;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.extend.Remoter;
import org.directwebremoting.servlet.JavaScriptHandler;
import org.directwebremoting.util.LocalUtil;

public class InterfaceHandler
extends JavaScriptHandler {
    protected Remoter remoter = null;
    protected String interfaceHandlerUrl;
    private static final Log log = LogFactory.getLog(InterfaceHandler.class);

    public InterfaceHandler() {
        this.setMimeType("text/javascript");
    }

    protected String generateTemplate(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String scriptName = request.getPathInfo();
        scriptName = scriptName.replace(this.interfaceHandlerUrl, "");
        if (!LocalUtil.isJavaIdentifier(scriptName = scriptName.replace(".js", ""))) {
            log.debug((Object)("Throwing at request for script with name: '" + scriptName + "'"));
            throw new SecurityException("Script names may only contain Java Identifiers");
        }
        String path = request.getContextPath() + request.getServletPath();
        return this.remoter.generateInterfaceScript(scriptName, path);
    }

    public void setRemoter(Remoter remoter) {
        this.remoter = remoter;
    }

    public void setInterfaceHandlerUrl(String interfaceHandlerUrl) {
        this.interfaceHandlerUrl = interfaceHandlerUrl;
    }

    public String toString() {
        return "InterfaceHandler(" + this.interfaceHandlerUrl + ")";
    }
}

