/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.servlet;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.Container;
import org.directwebremoting.WebContextFactory;

public class DwrWebContextFilter
implements Filter {
    private static final Log log = LogFactory.getLog(DwrWebContextFilter.class);
    private FilterConfig filterConfig;

    public void init(FilterConfig newFilterConfig) throws ServletException {
        this.filterConfig = newFilterConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        WebContextFactory.WebContextBuilder webContextBuilder;
        ServletConfig servletConfig;
        ServletContext servletContext = this.filterConfig.getServletContext();
        Container container = (Container)servletContext.getAttribute(Container.class.getName());
        if (container == null) {
            log.error((Object)"DwrWebContextFilter can not find ServletContext attribute for the DWR Container. Is DwrServlet configured in this web-application?");
        }
        if ((servletConfig = (ServletConfig)servletContext.getAttribute(ServletConfig.class.getName())) == null) {
            log.error((Object)"DwrWebContextFilter can not find ServletContext attribute for the ServletConfig.");
        }
        if ((webContextBuilder = (WebContextFactory.WebContextBuilder)servletContext.getAttribute(WebContextFactory.WebContextBuilder.class.getName())) == null) {
            log.error((Object)"DwrWebContextFilter can not find ServletContext attribute for the WebContextBuilder. WebContext will not be available.");
        } else {
            try {
                webContextBuilder.set((HttpServletRequest)request, (HttpServletResponse)response, servletConfig, servletContext, container);
                chain.doFilter(request, response);
            }
            finally {
                webContextBuilder.unset();
            }
        }
    }

    public void destroy() {
    }
}

