/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.impl;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.directwebremoting.Container;
import org.directwebremoting.extend.DownloadManager;
import org.directwebremoting.extend.FileGenerator;
import org.directwebremoting.extend.InitializingBean;
import org.directwebremoting.impl.AbstractFileGenerator;
import org.directwebremoting.impl.PurgingDownloadManager;
import org.directwebremoting.util.LocalUtil;

public class FileStoreDownloadManager
extends PurgingDownloadManager
implements DownloadManager,
InitializingBean {
    private static final String FILE_PREFIX = "dwr";
    private static final String PART_SEPARATOR = "-";
    protected Object contentsLock = new Object();
    protected File downloadFileCache = null;

    public void afterContainerSetup(Container container) {
        if (this.downloadFileCache == null) {
            FileOutputStream out;
            File tempFile;
            block7: {
                tempFile = null;
                out = null;
                try {
                    tempFile = File.createTempFile("dwr-test", ".tmp");
                    out = new FileOutputStream(tempFile);
                    ((OutputStream)out).write("test".getBytes());
                    this.downloadFileCache = tempFile.getParentFile();
                    if (this.downloadFileCache != null) break block7;
                    throw new IllegalArgumentException("Temp files written to null directory");
                }
                catch (IOException ex) {
                    try {
                        throw new IllegalArgumentException("Temp directory provided by the JVM is not writable. See downloadFileCacheDir to customize.");
                    }
                    catch (Throwable throwable) {
                        LocalUtil.close(out);
                        if (tempFile != null) {
                            tempFile.delete();
                        }
                        throw throwable;
                    }
                }
            }
            LocalUtil.close(out);
            if (tempFile != null) {
                tempFile.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void putFileGenerator(String id, FileGenerator generator) {
        String filename = "dwr-" + id + PART_SEPARATOR + generator.getMimeType().replace("/", ".") + PART_SEPARATOR + generator.getFilename();
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(filename);
            generator.generateFile(out);
            ((OutputStream)out).close();
        }
        catch (IOException ex) {
            try {
                log.error((Object)"Failed to write file to cache", (Throwable)ex);
            }
            catch (Throwable throwable) {
                LocalUtil.close(out);
                throw throwable;
            }
            LocalUtil.close(out);
        }
        LocalUtil.close(out);
    }

    protected FileGenerator getFileGenerator(String id) {
        final String prefix = "dwr-" + id + PART_SEPARATOR;
        final File[] match = this.downloadFileCache.listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.getName().startsWith(prefix);
            }
        });
        if (match.length == 0) {
            return null;
        }
        if (match.length > 1) {
            log.warn((Object)("More than 1 match for prefix: " + prefix + ". Using first."));
        }
        String[] parts = match[0].getName().split(PART_SEPARATOR, 4);
        String mimeType = parts[2].replace(".", "/");
        String filename = parts[3];
        return new AbstractFileGenerator(filename, mimeType){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void generateFile(OutputStream out) throws IOException {
                FileInputStream in = null;
                try {
                    int len;
                    in = new FileInputStream(match[0]);
                    byte[] buffer = new byte[1024];
                    while ((len = ((InputStream)in).read(buffer)) != 0) {
                        out.write(buffer, 0, len);
                    }
                }
                catch (Throwable throwable) {
                    LocalUtil.close(in);
                    match[0].delete();
                    throw throwable;
                }
                LocalUtil.close(in);
                match[0].delete();
            }
        };
    }

    protected void purge() {
        File[] match;
        final long now = System.currentTimeMillis();
        for (File file : match = this.downloadFileCache.listFiles(new FileFilter(){

            public boolean accept(File file) {
                boolean nameMatch = file.getName().startsWith(FileStoreDownloadManager.FILE_PREFIX);
                boolean oldEnough = now > file.lastModified() + FileStoreDownloadManager.this.purgeDownloadsAfter;
                return nameMatch && oldEnough;
            }
        })) {
            file.delete();
        }
    }

    public void setDownloadFileCacheDir(String downloadFileCacheDir) {
        this.downloadFileCache = new File(downloadFileCacheDir);
        if (!this.downloadFileCache.exists()) {
            throw new IllegalArgumentException("Download cache does not exist: " + downloadFileCacheDir);
        }
        if (!this.downloadFileCache.isDirectory()) {
            throw new IllegalArgumentException("Download cache is not a directory: " + downloadFileCacheDir);
        }
    }
}

