/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.extend;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.extend.ConverterManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeHintContext {
    private ConverterManager converterManager;
    private String cachedToString = null;
    private final Method method;
    private final int parameterNumber;
    private final Type parameterType;
    private final List<Integer> parameterNumberTree;
    private final List<Type> parameterTypeTree;
    private static final Log log = LogFactory.getLog(TypeHintContext.class);

    public TypeHintContext(ConverterManager converterManager, Method method, int parameterNumber) {
        if (method == null) {
            throw new IllegalArgumentException("The method can not be null");
        }
        this.converterManager = converterManager;
        this.method = method;
        this.parameterNumber = parameterNumber;
        Type[] types = method.getGenericParameterTypes();
        if (types != null && types.length > 0) {
            if (parameterNumber >= types.length) {
                throw new IllegalArgumentException("parameterNumber=" + parameterNumber + " is too big when method=" + method.getName() + " returns genericParameterTypes.length=" + types.length);
            }
            this.parameterType = types[parameterNumber];
        } else {
            this.parameterType = null;
        }
        this.parameterNumberTree = new ArrayList<Integer>();
        this.parameterTypeTree = new ArrayList<Type>();
    }

    private TypeHintContext(ConverterManager manager, Method method, int parameterNumber, Type parameterType) {
        this.converterManager = manager;
        this.method = method;
        this.parameterNumber = parameterNumber;
        this.parameterType = parameterType;
        this.parameterNumberTree = new ArrayList<Integer>();
        this.parameterTypeTree = new ArrayList<Type>();
    }

    public TypeHintContext createChildContext(int newParameterNumber) {
        Type childType = null;
        if (this.parameterType instanceof ParameterizedType) {
            ParameterizedType ptype = (ParameterizedType)this.parameterType;
            Type[] actualTypeArguments = ptype.getActualTypeArguments();
            if (newParameterNumber >= actualTypeArguments.length) {
                throw new IllegalArgumentException("newParameterNumber=" + newParameterNumber + " is too big when parameterType=" + this.parameterType + " give actualTypeArguments.length=" + actualTypeArguments.length);
            }
            childType = actualTypeArguments[newParameterNumber];
        }
        TypeHintContext child = new TypeHintContext(this.converterManager, this.method, this.parameterNumber, childType);
        child.parameterNumberTree.addAll(this.parameterNumberTree);
        child.parameterNumberTree.add(newParameterNumber);
        child.parameterTypeTree.addAll(this.parameterTypeTree);
        child.parameterTypeTree.add(this.parameterType);
        return child;
    }

    public Class<?> getExtraTypeInfo() {
        Class type;
        if (this.converterManager != null && (type = this.converterManager.getExtraTypeInfo(this)) != null) {
            log.debug((Object)("Using type info from <signature> " + this.toString() + " of " + type));
            return type;
        }
        if (this.parameterType instanceof ParameterizedType) {
            ParameterizedType ptype = (ParameterizedType)this.parameterType;
            Type rawType = ptype.getRawType();
            if (rawType instanceof Class) {
                type = (Class)rawType;
                log.debug((Object)("Using type info from JDK5 ParameterizedType of " + type.getName() + " for " + this.toString()));
                return type;
            }
        } else if (this.parameterType instanceof Class) {
            type = (Class)this.parameterType;
            log.debug((Object)("Using type info from JDK5 reflection of " + type.getName() + " for " + this.toString()));
            return type;
        }
        log.warn((Object)("Missing type info for " + this.toString() + ". Assuming this is a map with String keys. Please add to <signatures> in dwr.xml"));
        return String.class;
    }

    public int hashCode() {
        return this.method.hashCode() + this.parameterNumber + ((Object)this.parameterNumberTree).hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        TypeHintContext that = (TypeHintContext)obj;
        if (!this.method.equals(that.method)) {
            return false;
        }
        if (this.parameterNumber != that.parameterNumber) {
            return false;
        }
        return ((Object)this.parameterNumberTree).equals(that.parameterNumberTree);
    }

    public String toString() {
        if (this.cachedToString == null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(this.method.getName());
            buffer.append('(');
            buffer.append(this.parameterNumber);
            for (Integer i : this.parameterNumberTree) {
                buffer.append('<');
                buffer.append(i);
            }
            for (Integer i : this.parameterNumberTree) {
                buffer.append('>');
            }
            buffer.append(')');
            this.cachedToString = buffer.toString();
        }
        return this.cachedToString;
    }
}

