/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.dwrp;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.WebContextFactory;
import org.directwebremoting.dwrp.BaseScriptConduit;
import org.directwebremoting.dwrp.Html4kScriptConduit;
import org.directwebremoting.dwrp.HtmlScriptConduit;
import org.directwebremoting.dwrp.PartialResponse;
import org.directwebremoting.dwrp.PlainScriptConduit;
import org.directwebremoting.dwrp.PollBatch;
import org.directwebremoting.extend.Alarm;
import org.directwebremoting.extend.ContainerAbstraction;
import org.directwebremoting.extend.ConverterManager;
import org.directwebremoting.extend.EnginePrivate;
import org.directwebremoting.extend.Handler;
import org.directwebremoting.extend.PageNormalizer;
import org.directwebremoting.extend.RealScriptSession;
import org.directwebremoting.extend.RealWebContext;
import org.directwebremoting.extend.ScriptSessionManager;
import org.directwebremoting.extend.ServerException;
import org.directwebremoting.extend.ServerLoadMonitor;
import org.directwebremoting.extend.Sleeper;
import org.directwebremoting.impl.JettyContinuationSleeper;
import org.directwebremoting.impl.OutputAlarm;
import org.directwebremoting.impl.ShutdownAlarm;
import org.directwebremoting.impl.TimedAlarm;

public class PollHandler
implements Handler {
    protected boolean jsonOutput = false;
    protected boolean activeReverseAjaxEnabled = false;
    protected boolean allowGetForSafariButMakeForgeryEasier = false;
    protected int maxWaitAfterWrite = -1;
    protected boolean plain;
    protected PageNormalizer pageNormalizer;
    protected ServerLoadMonitor serverLoadMonitor = null;
    protected ConverterManager converterManager = null;
    protected ScriptSessionManager scriptSessionManager = null;
    protected ContainerAbstraction containerAbstraction = null;
    protected static final Log log = LogFactory.getLog(PollHandler.class);

    public PollHandler(boolean plain) {
        this.plain = plain;
    }

    public void handle(HttpServletRequest request, HttpServletResponse response) throws IOException {
        PollBatch batch;
        if (JettyContinuationSleeper.isRestart(request)) {
            JettyContinuationSleeper.restart(request);
            return;
        }
        try {
            batch = new PollBatch(request);
        }
        catch (ServerException ex) {
            String script = EnginePrivate.getRemoteHandleBatchExceptionScript(null, ex);
            this.sendErrorScript(response, script);
            return;
        }
        RealWebContext webContext = (RealWebContext)WebContextFactory.get();
        String normalizedPage = this.pageNormalizer.normalizePage(batch.getPage());
        webContext.checkPageInformation(normalizedPage, batch.getScriptSessionId(), batch.getWindowName());
        if (!this.activeReverseAjaxEnabled) {
            log.error((Object)"Polling and Comet are disabled. To enable them set the init-param activeReverseAjaxEnabled to true. See http://getahead.org/dwr/server/servlet for more.");
            String script = EnginePrivate.getRemotePollCometDisabledScript(batch.getBatchId());
            this.sendErrorScript(response, script);
            return;
        }
        if (batch.isGet() && !this.allowGetForSafariButMakeForgeryEasier) {
            String script = EnginePrivate.getRemoteHandleBatchExceptionScript(batch.getBatchId(), new SecurityException("GET Disallowed"));
            this.sendErrorScript(response, script);
            return;
        }
        final RealScriptSession scriptSession = (RealScriptSession)webContext.getScriptSession();
        final BaseScriptConduit conduit = this.createScriptConduit(batch, response);
        Sleeper sleeper = this.containerAbstraction.createSleeper(request);
        final ArrayList<Alarm> alarms = new ArrayList<Alarm>();
        alarms.add(conduit.getErrorAlarm());
        if (batch.getPartialResponse() == PartialResponse.NO || this.maxWaitAfterWrite != -1) {
            alarms.add(new OutputAlarm(scriptSession, this.maxWaitAfterWrite));
        }
        long maxConnectedTime = this.serverLoadMonitor.getConnectedTime();
        alarms.add(new TimedAlarm(maxConnectedTime));
        alarms.add(new ShutdownAlarm(this.serverLoadMonitor));
        for (Alarm alarm : alarms) {
            alarm.setAlarmAction(sleeper);
        }
        Runnable onAwakening = new Runnable(){

            public void run() {
                for (Alarm alarm : alarms) {
                    alarm.cancel();
                }
                scriptSession.removeScriptConduit(conduit);
                try {
                    int timeToNextPoll = PollHandler.this.serverLoadMonitor.getDisconnectedTime();
                    conduit.close(timeToNextPoll);
                }
                catch (IOException ex) {
                    log.warn((Object)"Failed to write reconnect info to browser");
                }
            }
        };
        scriptSession.addScriptConduit(conduit);
        sleeper.goToSleep(onAwakening);
    }

    private BaseScriptConduit createScriptConduit(PollBatch batch, HttpServletResponse response) throws IOException {
        BaseScriptConduit conduit = this.plain ? new PlainScriptConduit(response, batch.getBatchId(), this.converterManager, this.jsonOutput) : (batch.getPartialResponse() == PartialResponse.FLUSH ? new Html4kScriptConduit(response, batch.getBatchId(), this.converterManager, this.jsonOutput) : new HtmlScriptConduit(response, batch.getBatchId(), this.converterManager, this.jsonOutput));
        return conduit;
    }

    protected void sendErrorScript(HttpServletResponse response, String script) throws IOException {
        PrintWriter out = response.getWriter();
        if (this.plain) {
            response.setContentType("text/plain");
        } else {
            response.setContentType("text/html");
        }
        out.println("//#DWR-START#");
        out.println(script);
        out.println("//#DWR-END#");
    }

    public void setConverterManager(ConverterManager converterManager) {
        this.converterManager = converterManager;
    }

    public void setServerLoadMonitor(ServerLoadMonitor serverLoadMonitor) {
        this.serverLoadMonitor = serverLoadMonitor;
    }

    public void setPageNormalizer(PageNormalizer pageNormalizer) {
        this.pageNormalizer = pageNormalizer;
    }

    public void setScriptSessionManager(ScriptSessionManager scriptSessionManager) {
        this.scriptSessionManager = scriptSessionManager;
    }

    @Deprecated
    public void setPollAndCometEnabled(boolean pollAndCometEnabled) {
        this.activeReverseAjaxEnabled = pollAndCometEnabled;
    }

    public void setActiveReverseAjaxEnabled(boolean activeReverseAjaxEnabled) {
        this.activeReverseAjaxEnabled = activeReverseAjaxEnabled;
    }

    public void setAllowGetForSafariButMakeForgeryEasier(boolean allowGetForSafariButMakeForgeryEasier) {
        this.allowGetForSafariButMakeForgeryEasier = allowGetForSafariButMakeForgeryEasier;
    }

    public void setContainerAbstraction(ContainerAbstraction containerAbstraction) {
        this.containerAbstraction = containerAbstraction;
    }

    public void setMaxWaitAfterWrite(int maxWaitAfterWrite) {
        this.maxWaitAfterWrite = maxWaitAfterWrite;
    }

    public boolean isJsonOutput() {
        return this.jsonOutput;
    }

    public void setJsonOutput(boolean jsonOutput) {
        this.jsonOutput = jsonOutput;
    }
}

