/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.dwrp;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.extend.Alarm;
import org.directwebremoting.extend.ConverterManager;
import org.directwebremoting.extend.EnginePrivate;
import org.directwebremoting.extend.ScriptConduit;
import org.directwebremoting.impl.BasicAlarm;
import org.directwebremoting.util.DebuggingPrintWriter;

public abstract class BaseScriptConduit
extends ScriptConduit {
    protected boolean debugScriptOutput = false;
    protected boolean jsonOutput = false;
    protected ConverterManager converterManager = null;
    protected final HttpServletResponse response;
    protected PrintWriter out;
    protected final String batchId;
    protected BasicAlarm alarm = new BasicAlarm();
    private static final Log log = LogFactory.getLog(BaseScriptConduit.class);

    public BaseScriptConduit(HttpServletResponse response, String batchId, ConverterManager converterManager, boolean jsonOutput) throws IOException {
        super(1);
        this.response = response;
        this.batchId = batchId;
        this.converterManager = converterManager;
        this.jsonOutput = jsonOutput;
        response.setContentType(this.getOutboundMimeType());
        this.out = response.getWriter();
        if (this.debugScriptOutput && log.isDebugEnabled()) {
            DebuggingPrintWriter dpw = new DebuggingPrintWriter("", this.out);
            dpw.setPrefix("out(" + this.hashCode() + "): ");
            this.out = dpw;
        }
        this.beginStream();
    }

    protected abstract String getOutboundMimeType();

    protected abstract void beginStream();

    protected abstract void endStream();

    public void close(int timetoNextPoll) throws IOException {
        try {
            EnginePrivate.remoteHandleCallback(this, this.batchId, "0", timetoNextPoll);
        }
        catch (Exception ex) {
            EnginePrivate.remoteHandleException(this, this.batchId, "0", ex);
            log.warn((Object)("--Erroring: batchId[" + this.batchId + "] message[" + ex.toString() + ']'), (Throwable)ex);
        }
        this.endStream();
    }

    protected boolean flush() {
        this.out.flush();
        if (this.out.checkError()) {
            log.debug((Object)"Error writing to stream");
            return false;
        }
        try {
            this.response.flushBuffer();
            return true;
        }
        catch (IOException ex) {
            log.debug((Object)("Error writing to HTTP response:" + ex));
            this.alarm.raiseAlarm();
            return false;
        }
    }

    public void setDebugScriptOutput(boolean debugScriptOutput) {
        this.debugScriptOutput = debugScriptOutput;
    }

    public Alarm getErrorAlarm() {
        return this.alarm;
    }
}

