/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.convert;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.convert.BaseV20Converter;
import org.directwebremoting.dwrp.ArrayJsonOutboundVariable;
import org.directwebremoting.dwrp.ArrayNonJsonOutboundVariable;
import org.directwebremoting.dwrp.CollectionOutboundVariable;
import org.directwebremoting.dwrp.ErrorOutboundVariable;
import org.directwebremoting.dwrp.ParseUtil;
import org.directwebremoting.extend.Converter;
import org.directwebremoting.extend.ConverterManager;
import org.directwebremoting.extend.InboundContext;
import org.directwebremoting.extend.InboundVariable;
import org.directwebremoting.extend.MarshallException;
import org.directwebremoting.extend.OutboundContext;
import org.directwebremoting.extend.OutboundVariable;
import org.directwebremoting.extend.TypeHintContext;
import org.directwebremoting.util.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionConverter
extends BaseV20Converter
implements Converter {
    private ConverterManager converterManager = null;
    private static final Log log = LogFactory.getLog(CollectionConverter.class);

    @Override
    public void setConverterManager(ConverterManager converterManager) {
        this.converterManager = converterManager;
    }

    @Override
    public Object convertInbound(Class<?> paramType, InboundVariable data, InboundContext inctx) throws MarshallException {
        String value = data.getValue();
        if (value.trim().equals("null")) {
            return null;
        }
        if (!value.startsWith("[")) {
            throw new MarshallException(paramType, Messages.getString("CollectionConverter.FormatError", "["));
        }
        if (!value.endsWith("]")) {
            throw new MarshallException(paramType, Messages.getString("CollectionConverter.FormatError", "]"));
        }
        value = value.substring(1, value.length() - 1);
        try {
            Collection<Object> col;
            TypeHintContext icc = inctx.getCurrentTypeHintContext();
            TypeHintContext subthc = icc.createChildContext(0);
            Class<?> subtype = subthc.getExtraTypeInfo();
            if (Iterator.class.isAssignableFrom(paramType)) {
                col = new ArrayList();
            } else if (!paramType.isInterface() && !Modifier.isAbstract(paramType.getModifiers())) {
                col = (Collection)paramType.newInstance();
            } else if (SortedSet.class.isAssignableFrom(paramType)) {
                col = new TreeSet();
            } else if (Set.class.isAssignableFrom(paramType)) {
                col = new HashSet();
            } else if (List.class.isAssignableFrom(paramType)) {
                col = new ArrayList();
            } else if (Collection.class.isAssignableFrom(paramType)) {
                col = new ArrayList();
            } else {
                throw new MarshallException(paramType);
            }
            inctx.addConverted(data, paramType, col);
            StringTokenizer st = new StringTokenizer(value, ",");
            int size = st.countTokens();
            for (int i = 0; i < size; ++i) {
                String token = st.nextToken();
                String[] split = ParseUtil.splitInbound(token);
                String splitType = split[0];
                String splitValue = split[1];
                InboundVariable nested = new InboundVariable(data.getLookup(), null, splitType, splitValue);
                nested.dereference();
                Object output = this.converterManager.convertInbound(subtype, nested, inctx, subthc);
                col.add(output);
            }
            if (Iterator.class.isAssignableFrom(paramType)) {
                return col.iterator();
            }
            return col;
        }
        catch (Exception ex) {
            throw new MarshallException(paramType, (Throwable)ex);
        }
    }

    @Override
    public OutboundVariable convertOutbound(Object data, OutboundContext outctx) throws MarshallException {
        Iterator it;
        if (data instanceof Collection) {
            Collection col = (Collection)data;
            it = col.iterator();
        } else if (data instanceof Iterator) {
            it = (Iterator)data;
        } else {
            throw new MarshallException(data.getClass());
        }
        CollectionOutboundVariable ov = outctx.isJsonMode() ? new ArrayJsonOutboundVariable() : new ArrayNonJsonOutboundVariable(outctx);
        outctx.put(data, ov);
        ArrayList<OutboundVariable> ovs = new ArrayList<OutboundVariable>();
        while (it.hasNext()) {
            OutboundVariable nested;
            Object member = it.next();
            try {
                nested = this.converterManager.convertOutbound(member, outctx);
            }
            catch (Exception ex) {
                String errorMessage = "Conversion error for " + data.getClass().getName() + ".";
                log.warn((Object)errorMessage, (Throwable)ex);
                nested = new ErrorOutboundVariable(errorMessage);
            }
            ovs.add(nested);
        }
        ov.setChildren(ovs);
        return ov;
    }
}

