/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.bayeux;

import dojox.cometd.Bayeux;
import java.util.List;
import javax.servlet.ServletContextAttributeEvent;
import javax.servlet.ServletContextAttributeListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.Container;
import org.directwebremoting.bayeux.BayeuxClient;
import org.directwebremoting.dwrp.PlainCallMarshaller;
import org.directwebremoting.extend.ConverterManager;
import org.directwebremoting.extend.Remoter;

public class BayeuxServletContextAttributeListener
implements ServletContextAttributeListener {
    private BayeuxClient bayeuxHandler;
    private Remoter remoter;
    private ConverterManager converterManager;
    private PlainCallMarshaller plainCallMarshaller;
    private static final Log log = LogFactory.getLog(BayeuxServletContextAttributeListener.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attributeAdded(ServletContextAttributeEvent scab) {
        BayeuxServletContextAttributeListener bayeuxServletContextAttributeListener = this;
        synchronized (bayeuxServletContextAttributeListener) {
            if (this.bayeuxHandler == null && "dojox.cometd.bayeux".equals(scab.getName())) {
                Bayeux bayeux = (Bayeux)scab.getValue();
                this.bayeuxHandler = new BayeuxClient(bayeux);
                if (this.remoter != null) {
                    this.bayeuxHandler.setRemoter(this.remoter);
                }
                if (this.converterManager != null) {
                    this.bayeuxHandler.setConverterManager(this.converterManager);
                }
                if (this.plainCallMarshaller != null) {
                    this.bayeuxHandler.setPlainCallMarshaller(this.plainCallMarshaller);
                }
            }
            if ("org.directwebremoting.ContainerList".equals(scab.getName())) {
                List containers = (List)scab.getValue();
                log.debug((Object)("containers=" + containers));
                for (Container container : containers) {
                    PlainCallMarshaller p;
                    ConverterManager c;
                    log.debug((Object)("container=" + container));
                    log.debug((Object)("beans=" + container.getBeanNames()));
                    Remoter r = (Remoter)container.getBean("org.directwebremoting.extend.Remoter");
                    if (r != null) {
                        this.remoter = r;
                        if (this.bayeuxHandler != null) {
                            this.bayeuxHandler.setRemoter(this.remoter);
                        }
                        log.debug((Object)("remoter=" + this.remoter));
                    }
                    if ((c = (ConverterManager)container.getBean("org.directwebremoting.extend.ConverterManager")) != null) {
                        this.converterManager = c;
                        if (this.bayeuxHandler != null) {
                            this.bayeuxHandler.setConverterManager(this.converterManager);
                        }
                        log.debug((Object)("converterManager=" + this.converterManager));
                    }
                    if ((p = (PlainCallMarshaller)container.getBean("org.directwebremoting.dwrp.PlainCallMarshaller")) == null) continue;
                    this.plainCallMarshaller = p;
                    if (this.bayeuxHandler != null) {
                        this.bayeuxHandler.setPlainCallMarshaller(this.plainCallMarshaller);
                    }
                    log.debug((Object)("plainCallMarshaller=" + this.plainCallMarshaller));
                }
            }
        }
    }

    public void attributeRemoved(ServletContextAttributeEvent scab) {
    }

    public void attributeReplaced(ServletContextAttributeEvent scab) {
    }
}

