/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.bayeux;

import dojox.cometd.Bayeux;
import dojox.cometd.Client;
import dojox.cometd.Listener;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.bayeux.BayeuxScriptConduit;
import org.directwebremoting.dwrp.Batch;
import org.directwebremoting.dwrp.PlainCallMarshaller;
import org.directwebremoting.extend.Call;
import org.directwebremoting.extend.Calls;
import org.directwebremoting.extend.ConverterManager;
import org.directwebremoting.extend.EnginePrivate;
import org.directwebremoting.extend.FormField;
import org.directwebremoting.extend.Remoter;
import org.directwebremoting.extend.Replies;
import org.directwebremoting.extend.Reply;
import org.directwebremoting.extend.ScriptConduit;

public class BayeuxClient
implements Listener {
    private static final boolean JSON_OUTPUT = false;
    private Bayeux bayeux;
    private Client client;
    private Remoter remoter;
    private ConverterManager converterManager;
    private PlainCallMarshaller plainCallMarshaller;
    private static final Log log = LogFactory.getLog(BayeuxClient.class);

    public BayeuxClient(Bayeux bayeux) {
        this.bayeux = bayeux;
        this.client = bayeux.newClient("dwr", (Listener)this);
        bayeux.subscribe("/dwr", this.client);
    }

    public void deliver(Client fromClient, String toChannel, Object message, String msgId) {
        try {
            Map msgParams = (Map)message;
            HashMap<String, FormField> fileParams = new HashMap<String, FormField>(msgParams.size());
            for (Map.Entry entry : msgParams.entrySet()) {
                String param = (String)entry.getValue();
                FormField formField = new FormField(param);
                fileParams.put((String)entry.getKey(), formField);
            }
            Batch batch = new Batch(fileParams);
            Calls calls = this.plainCallMarshaller.marshallInbound(batch);
            log.debug((Object)("Calls=" + calls));
            for (int i = 0; i < calls.getCallCount(); ++i) {
                Call call = calls.getCall(i);
                Object[] params = call.getParameters();
                log.debug((Object)("Call[" + i + "]=" + call.getScriptName() + "." + call.getMethodName() + (params == null ? "[]" : Arrays.asList(params))));
            }
            Replies replies = this.remoter.execute(calls);
            BayeuxScriptConduit conduit = new BayeuxScriptConduit(this.converterManager, false);
            for (Reply reply : replies) {
                String batchId = calls.getBatchId();
                log.debug((Object)("Reply=" + reply + " BatchId=" + batchId));
                if (reply.getThrowable() != null) {
                    Throwable ex = reply.getThrowable();
                    EnginePrivate.remoteHandleException(conduit, batchId, reply.getCallId(), ex);
                    log.warn((Object)("--Erroring: batchId[" + batchId + "] message[" + ex.toString() + ']'));
                    continue;
                }
                Object data = reply.getReply();
                log.debug((Object)("data=" + data));
                EnginePrivate.remoteHandleCallback(conduit, batchId, reply.getCallId(), data);
            }
            String output = ((ScriptConduit)conduit).toString();
            log.debug((Object)("<< " + output));
            this.bayeux.publish(this.client, "/dwr/" + fromClient.getId(), (Object)output, calls.getBatchId());
        }
        catch (Exception ex) {
            log.warn((Object)"Protocol Error", (Throwable)ex);
        }
    }

    public void removed(String clientId, boolean timeout) {
    }

    public void setRemoter(Remoter remoter) {
        this.remoter = remoter;
    }

    public void setConverterManager(ConverterManager converterManager) {
        this.converterManager = converterManager;
    }

    public void setPlainCallMarshaller(PlainCallMarshaller plainCallMarshaller) {
        this.plainCallMarshaller = plainCallMarshaller;
    }
}

